<!-- app-header -->
<?php
/*
Template Name: لیست کاربران
*/
check_access();
if (isset($_SESSION['user_info'])) {
    $user_info = $_SESSION['user_info'];
    $user_key_protection = $user_info['key_protection'];
}
echo '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>';
if (isset($_GET['action_delete']) && !empty($_GET['action_delete'])) {
    $table = "custom_users";
    $cand_delete = can_delete_item("user", $_GET['action_delete']);
    if ($cand_delete !== true) {
        $cand_delete_escaped = json_encode($cand_delete, JSON_UNESCAPED_UNICODE);
        echo "
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                document.body.classList.add('swal-open'); 
                Swal.fire({
                    icon: 'error',
                    title: 'خطا',
                    html: $cand_delete_escaped,
                    confirmButtonText: 'متوجه شدم',
                    willClose: () => {
                        document.body.classList.remove('swal-open');
                        document.querySelector('.swal-overlay').remove();
                    },
                }).then(() => {
                    // حذف کوئری استرینگ بدون رفرش صفحه
                    const newUrl = window.location.origin + window.location.pathname;
                    history.replaceState(null, '', newUrl);
                });
            });
        </script>
        ";
    }
    else{
    $delete = get_delete($table, $_GET['action_delete']);
    if ($delete) {
        header("Location:" . site_url('users/?delete=success'));
        exit;
    }
}
}
if (isset($_GET['delete']) && $_GET['delete'] == 'success') {
    echo "
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
            document.body.classList.add('swal-open'); 
            Swal.fire({
                icon: 'success',
                title: 'حذف موفقیت آمیز!',
                text: 'کاربر با موفقیت حذف شد',
                confirmButtonText: 'متوجه شدم',
                timer: 5000,
                timerProgressBar: true,
                willClose: () => {
                            document.body.classList.remove('swal-open');
                            document.querySelector('.swal-overlay').remove();
                        },
            }).then(() => {
            // حذف کوئری استرینگ بدون رفرش صفحه
            const newUrl = window.location.origin + window.location.pathname;
            history.replaceState(null, '', newUrl);
        });
        });
    </script>
    ";
}
get_header() ?>
<!-- /app-header -->
<!-- Start::app-sidebar -->
<?php include 'sidebar.php' ?>
<!-- End::app-sidebar -->

<!-- Start::app-content -->
<div class="main-content app-content">
    <div class="container-fluid">

        <!-- Page Header -->

        <div class="d-md-flex d-block align-items-center justify-content-between page-header-breadcrumb">
            <div>
                <h2 class="main-content-title fs-24 mb-1">لیست کاربران</h2>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">کاربران</a></li>
                    <li class="breadcrumb-item active" aria-current="page">لیست کاربران</li>
                </ol>
            </div>
        </div>

        <!-- Page Header Close -->

        <!-- Start::row-1 -->
        <div class="row">
            <div class="card custom-card">
                <div class="card-body">
                    <div class="row rows">
                        <div class="col-xl-4 searched">
                            <form action="" name="search" method="get" class="search-form">
                                <div class="input-group slector">
                                    <div class="input-group-btn search-panel">
                                        <select class="js-example-basic-single" name="type" data-trigger>
                                            <option value="" disabled selected>انتخاب بر اساس</option>
                                            <option value="regional_manager">مدیر منطقه</option>
                                            <option value="representative">نماینده</option>
                                        </select>
                                    </div>
                                    <input type="text" class="form-control" name="q" id="typehead"
                                        placeholder="جست و جو کنید..." autocomplete="off">
                                    <button type="submit" class="btn btn-primary"><i class="fe fe-search"
                                            aria-hidden="true"></i></button>
                                </div>
                            </form>
                        </div>
                        <!-- <div class="col-xl-4 delete">
                                        <button type="submit" class="btn btn-delete" target="#">
                                            <i class="ri-delete-bin-5-line"></i>
                                        </button>
                                    </div> -->
                    </div>
                    <?php
                    $paged = (get_query_var('paged')) ? absint(get_query_var('paged')) : 1;
                    $posts_per_page = 10;

                    $type = isset($_GET['type']) ? $_GET['type'] : '';
                    $q = isset($_GET['q']) ? $_GET['q'] : '';

                    $data = get_result_users('custom_users', $q, $type, $paged, $posts_per_page);
                    $results = $data['results'];
                    $total_pages = $data['total_pages'];
                    ?>
                    <form action="" class="form-users" method="post">
                        <div class="table-responsive custom-scrollbar">
                            <table class="table text-nowrap table-bordered text-nowrap table-hover">
                                <thead class="head-users-table">
                                    <tr>
                                        <!-- <th>
                                                    <span class="check-slector">
                                                        <input
                                                            class="form-check-input form-checked-success all-selected"
                                                            type="checkbox" value="" id="all-slected" checked="">
                                                        <label for="all-slected">شناسه کاربری</label>
                                                    </span>
                                                </th> -->
                                        <th>نام و نام خانوادگی</th>
                                        <th>کد ملی</th>
                                        <th>شماره همراه</th>
                                        <th>نقش کاربری</th>
                                        <th>ایمیل</th>
                                        <th>نام کاربری</th>
                                        <th>تاریخ عضویت</th>
                                        <th>عملیات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($results) { ?>
                                    <?php foreach ($results as $row) : ?>
                                    <tr>
                                        <!-- <td style="width:0">
                                                    <span class="check-slector">
                                                        <input
                                                            class="form-check-input form-checked-success all-selected"
                                                            type="checkbox" value="" id="checked1">
                                                        <label for="checked1">#1</label>
                                                    </span>
                                                </td> -->
                                        <th scope="row">
                                            <div class="d-flex align-items-center">
                                                <span data-bs-original-title="<?= $row->fl_name ?>"
                                                    class="avatar avatar-xs me-2 avatar-rounded">
                                                    <img src="<?= $row->profile ? $row->profile : get_template_directory_uri(). '/assets/images/profile/defualt.jpg' ?>"
                                                        alt="img">
                                                </span><?= $row->fl_name ?>
                                            </div>
                                        </th>
                                        <td><?= $row->postal_code ?></td>
                                        <td><?= $row->phone ?></td>
                                        <td>
                                            <?php switch ($row->user_role) {
                                                        case 'admin_site':
                                                            echo 'مدیر سایت';
                                                            break;
                                                        case 'admin':
                                                            echo 'مدیر کل';
                                                            break;
                                                        case 'regional_manager':
                                                            echo 'مدیر منطقه';
                                                            break;
                                                        case 'representative':
                                                            echo 'نماینده';
                                                            break;
                                                    } ?>
                                        </td>
                                        <td><?= $row->email ?></td>
                                        <td><?= $row->username ?></td>
                                        <td><?= jdate("Y/m/d", strtotime($row->created_at)) ?></td>
                                        <td>
                                            <div class="hstack gap-2 flex-wrap">
                                                <?php if($user_info['user_role'] == 'admin' && $row->key_protection !== $user_info['key_protection'] && $row->user_role == "admin") { ?>
                                                <span class="tooltip-btn" data-tooltip="عدم دسترسی">
                                                    <i class="fa-solid fa-do-not-enter"></i>
                                                </span>
                                                <?php  } else{ ?>
                                                <a href="<?= site_url("users/edit-user/?action_edit=$row->key_protection") ?>"
                                                    class="text-info fs-14 lh-1"><i class="ri-edit-line"></i></a>
                                                <?php if($row->key_protection != $user_key_protection) { ?>
                                                <a href="#" class="text-danger fs-14 lh-1 delete-btn"
                                                    data-url="<?= site_url("users/?action_delete=$row->id") ?>">
                                                    <i class="ri-delete-bin-5-line"></i>
                                                </a>
                                                <?php } ?>
                                                <?php } ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach ?>
                                    <?php } else { ?>
                                    <tr>
                                        <td colspan="6" class="alert alert-danger">هیچ کاربری یافت نشد</td>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </form>
                    <!-- Pagination -->
                    <nav aria-label="Page navigation">
                        <ul class="pagination justify-content-center">
                            <?php
                                $pagination_links = paginate_links([
                                    'total' => $total_pages,
                                    'current' => $paged,
                                    'format' => '?paged=%#%',
                                    'show_all' => false,
                                    'type' => 'array',
                                    'end_size' => 1,
                                    'mid_size' => 2,
                                    'prev_next' => true,
                                    'prev_text' => __('قبلی'),
                                    'next_text' => __('بعدی'),
                                    'add_args' => false,
                                    'add_fragment' => '',
                                ]);

                                if ($pagination_links) {
                                    foreach ($pagination_links as $link) {
                                        $active_class = (strpos($link, 'current') !== false) ? 'active' : '';
                                        echo '<li class="page-item ' . $active_class . '">' . str_replace('page-numbers', 'page-link', $link) . '</li>';
                                    }
                                }
                                ?>
                        </ul>
                    </nav>
                    <!-- End Pagination -->
                </div>
            </div>
        </div>
        <!--End::row-1 -->

    </div>
</div>
<!-- End::app-content -->
<!-- message sweetalert -->
<script>
document.addEventListener("DOMContentLoaded", function() {
    document.querySelectorAll(".delete-btn").forEach(button => {
        button.addEventListener("click", function(event) {
            event.preventDefault(); // جلوگیری از رفتن به لینک مستقیماً

            let deleteUrl = this.getAttribute("data-url"); // گرفتن لینک حذف

            Swal.fire({
                title: "آیا مطمئن هستید؟",
                text: "این عملیات قابل بازگشت نیست!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#db4040",
                cancelButtonColor: "#3085d6",
                confirmButtonText: "بله، حذف شود!",
                cancelButtonText: "لغو"
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href =
                        deleteUrl; // انتقال به لینک حذف در صورت تأیید
                }
            });
        });
    });
});
</script>
<!-- end message sweetalert -->
<!-- Footer Start -->
<?php get_footer() ?>
<!-- Footer End -->