<?php
/*
Template Name: ثبت پیش فاکتور
*/
check_access();
if(isset($_SESSION['user_info'])){
    $user_info = $_SESSION['user_info'];
    $session_id = $user_info['id'];
    $user_role = $user_info['user_role'];
    $parent_id = $user_info['parent_id'];
}
get_header();
if(isset($_GET['error_message'])){
    echo "
    <script>
                document.addEventListener('DOMContentLoaded', function() {
                    document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                    document.body.classList.add('swal-open'); 
                    Swal.fire({
                        icon: 'error',
                        title: 'خطا!',
                        html: 'لطفا ابتدا یکی از نمایندگان زیر مجموعه ی خود را انتخاب نمایید',
                        confirmButtonText: 'متوجه شدم',
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        didOpen: () => {
                            document.querySelector('.swal2-container').classList.add('swal-active');
                        },
                        willClose: () => {
                            document.body.classList.remove('swal-open');
                            document.querySelector('.swal-overlay').remove();
                        },
                    }).then(() => {
            // حذف کوئری استرینگ بدون رفرش صفحه
            const newUrl = window.location.origin + window.location.pathname;
            history.replaceState(null, '', newUrl);
        });
                });
            </script>
    ";
}
get_sidebar();
?>
<!-- Start::app-content -->
<div class="main-content app-content">
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="d-md-flex d-block align-items-center justify-content-between page-header-breadcrumb">
            <div>
                <h2 class="main-content-title fs-24 mb-1">ثبت پیش فاکتور</h2>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item active" aria-current="page">ثبت پیش فاکتور</li>
                </ol>
            </div>
        </div>
        <!-- Page Header Close -->

        <!-- Start::row-1 -->
        <div class="row">
            <?php
            $paged = (get_query_var('paged')) ? absint(get_query_var('paged')) : 1;
            $posts_per_page = 9;
            $data = get_result_banks_orders('custom_banks', $paged, $posts_per_page);
            $banks = $data['results'];
            $total_pages = $data['total_pages'];
            $namayandeh = get_namayandeh($session_id);
            if ($banks) {
                foreach ($banks as $bank):
            ?>
            <div class="col-sm-12 col-xl-3">
                <form action="<?= site_url("register_proforma_invoice/products_list") ?>" method="get">
                    <div class="card custom-card">
                        <div class="card-title title_card">طرح بانک <?= $bank->bank_name ?></div>
                        <input type="text" hidden name="bank_name" value="<?= $bank->slug ?>">
                        <div class="text-center"><img class="img_logo img-fluid" src="<?= $bank->logo_url ?>"
                                alt="<?= $bank->bank_name ?>"></div>
                                <?php if($user_info['user_role'] == 'representative') {
                                    echo '';
                                } else{ ?>
                        <div class="selector" style="max-width: 80%;">
                            <select name="agent" id="inputState" class="form-select form-select-lg">
                                <?php foreach ($namayandeh as $ress): ?>
                                <option value="<?= $ress->username ?>">نماینده محترم <?= $ress->fl_name ?></option>
                                <?php endforeach ?>
                            </select>
                        </div><br>
                        <?php } ?>
                        <div class="selector" style="max-width: 80%;">
                            <select name="aghsat" id="inputState" class="form-select form-select-lg">
                                <?php
                                 $aghsat = get_resultt("custom_aghsat", $bank->id );
                                foreach ($aghsat as $ghest): ?>
                                <option value="<?= $ghest->slug ?>"><?= $ghest->ghest_time ?> ماهه</option>
                                <?php endforeach ?>
                            </select>
                        </div>
                        <br>
                        <div class="buttn_send">
                            <button type="submit" class="btn btn-primary send-btn">مرحله ی بعدی</button>
                        </div>
                        <br>
                    </div>
                </form>
            </div>
            <?php endforeach ?>
            <?php } else { ?>
            <div class="badge bg-danger bg-lg" style="font-size: 20px;">هیچ طرحی برای انتخاب وجود ندارد</div>
            <?php } ?>
            <!-- Pagination -->
            <nav aria-label="Page navigation">
                <ul class="pagination justify-content-center">
                    <?php
                    $pagination_links = paginate_links([
                        'total' => $total_pages,
                        'current' => $paged,
                        'format' => '?paged=%#%',
                        'show_all' => false,
                        'type' => 'array',
                        'end_size' => 1,
                        'mid_size' => 2,
                        'prev_next' => true,
                        'prev_text' => __('قبلی'),
                        'next_text' => __('بعدی'),
                        'add_args' => false,
                        'add_fragment' => '',
                    ]);

                    if ($pagination_links) {
                        foreach ($pagination_links as $link) {
                            $active_class = (strpos($link, 'current') !== false) ? 'active' : '';
                            echo '<li class="page-item ' . $active_class . '">' . str_replace('page-numbers', 'page-link', $link) . '</li>';
                        }
                    }
                    ?>
                </ul>
            </nav>
            <!-- End Pagination -->
        </div>
        <!-- End::row-1 -->
    </div>
</div>
<!-- End::app-content -->
<?php get_footer() ?>