<?php
/*
Template Name: ثبت و ویرایش اطلاعات مشتری          
*/
include 'actions/action-users.php';
if (!isset($_GET['invoice_id']) || empty($_GET['invoice_id'])) {
    get_template_part("404");
    exit;
} else {
    $invoice_id = $_GET['invoice_id'];
    $invoice = get_invoice_by_id($invoice_id);
    $row = select_customer_by_id($invoice->id);
    if (!$invoice || $invoice->id != $invoice_id) {
        get_template_part("404");
        exit;
    } else {
        // Set the dynamic title
        add_filter('wp_title', function ($title) use ($invoice) {
            return 'ثبت و ویرایش اطلاعات مشتری شماره فاکتور ' . "($invoice->id)";
        });

        add_filter('the_title', function ($title) use ($invoice) {
            return 'ثبت و ویرایش اطلاعات مشتری شماره فاکتور ' . "($invoice->id)";
        });
    }
}
get_header();
get_sidebar();
?>

<!-- Start::app-content -->
<div class="main-content app-content">
    <div class="container-fluid">

        <!-- Page Header -->

        <div class="d-md-flex d-block align-items-center justify-content-between page-header-breadcrumb">
            <div>
                <h2 class="main-content-title fs-24 mb-1">ثبت و ویرایش اطلاعات مشتری شماره فاکتور <?= $invoice->id ?>
                </h2>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">مدیریت فاکتور ها</a></li>
                    <li class="breadcrumb-item active" aria-current="page">ثبت و ویرایش اطلاعات مشتری</li>
                </ol>
            </div>

        </div>

        <!-- Page Header Close -->
        <?php
        if (!empty($message)) {
            echo "
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                    document.body.classList.add('swal-open'); 
                    Swal.fire({
                        icon: 'error',
                        title: 'خطا!',
                        html: '$message',
                        confirmButtonText: 'متوجه شدم',
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        didOpen: () => {
                            document.querySelector('.swal2-container').classList.add('swal-active');
                        },
                        willClose: () => {
                            document.body.classList.remove('swal-open');
                            document.querySelector('.swal-overlay').remove();
                        },
                    });
                });
            </script>
            ";
        }
        ?>

        <!-- Start:: row-1 -->
        <div class="row row-sm">
            <div class="col-xl-9" style="margin: 0 auto;">
                <div class="card custom-card">
                    <div class="card-header custom-card-header justify-content-between">
                        <div class="card-title">
                            <i class="fa-light fa-user custom-icon"></i>
                            ثبت و ویرایش اطلاعات مشتری شماره فاکتور <?php echo $invoice->id; ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="row g-3 mt-0" action="" method="post" enctype="multipart/form-data">
                            <!-- key_protection -->
                            <input type="text" name="key_protection" hidden class="form-control" value="<?php
                   if (!empty($row)) {
                       echo $row->key_protection;
                   } elseif (!empty(old('key_protection'))) {
                       echo old('key_protection');
                   } else {
                       echo md5(time());
                   }
               ?>">
                        <input type="hidden" name="invoice_id" class="form-control" value="<?= $invoice_id ?>">
                            <!-- نام و نام خانوادگی -->
                            <div class="col-md-6">
                                <label class="form-label">نام و نام خانوادگی<span class="required">*</span></label>
                                <input type="text" name="fl_name" class="form-control"
                                    placeholder="نام و نام خانوادگی را وارد کنید"
                                    value="<?php echo !empty($row) ? $row->fl_name : old('fl_name'); ?>">
                            </div>

                            <!-- کد ملی -->
                            <div class="col-md-6">
                                <label class="form-label">کد ملی<span class="required">*</span></label>
                                <input type="text" name="postal_code" class="form-control postal-code"
                                    placeholder="کد ملی را وارد نمایید"
                                    value="<?php echo !empty($row) ? $row->postal_code : old('postal_code'); ?>">
                            </div>

                            <!-- نام پدر -->
                            <div class="col-md-6">
                                <label class="form-label">نام پدر<span class="required">*</span></label>
                                <input type="text" name="father_name" class="form-control"
                                    placeholder="نام پدر را وارد نمایید"
                                    value="<?php echo !empty($row) ? $row->father_name : old('father_name'); ?>">
                            </div>

                            <!-- شماره همراه -->
                            <div class="col-md-6">
                                <label class="form-label">شماره همراه<span class="required">*</span></label>
                                <input type="text" name="phone_number" class="form-control days_invoice"
                                    placeholder="شماره همراه را وارد نمایید"
                                    value="<?php echo !empty($row) ? $row->phone_number : old('phone_number'); ?>">
                            </div>
                            
                            <!-- مبلغ وام -->
                            <div class="col-md-6">
                                <label class="form-label">مبلغ وام<span class="required">*</span></label>
                                <div class="input-group">
                                    <input type="text" name="loan_amount"
                                    value="<?php echo !empty($row) ? $row->loan_amount : old('loan_amount'); ?>"
                                    class="form-control price" placeholder=" مبلغ وام را وارد نمایید">
                                    <span class="input-group-text">
                                        تومان
                                    </span>
                                </div>
                            </div>

                            <!-- کد پستی -->
                            <div class="col-md-6">
                                <label class="form-label">کد پستی<span class="required">*</span></label>
                                <input type="text" name="zipcode" class="form-control zipcode"
                                    placeholder="کد پستی را وارد نمایید"
                                    value="<?php echo !empty($row) ? $row->zipcode : old('zipcode'); ?>">
                            </div>

                            <!-- آدرس کامل -->
                            <div class="col-md-12">
                                <label class="form-label">آدرس کامل<span class="required">*</span></label>
                                <textarea class="form-control" name="address"><?php echo !empty($row) ? $row->address : old('address'); ?></textarea>
                            </div>

                            <!-- دکمه ثبت -->
                            <div class="col-12 text-center">
                                <button type="submit" name="save_customer" class="btn btn-primary btn-lg text">
                                    ثبت مشخصات مشتری
                                </button>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
        <!-- End:: row-1 -->
    </div>
</div>
<!-- End::app-content -->

<!-- Footer Start -->
<?php get_footer() ?>
<!-- Footer End -->