<?php
/*
Template Name:  ثبت نام
*/
if(isset($_SESSION['user_info'])){
    wp_redirect(site_url());
    exit;
}
if(isset($_GET['ref']) && !empty($_GET['ref'])){
    $ref = sanitize_text_field($_GET['ref']);
   $key = get_result_key("custom_users", $ref);
   if(!$key || $key->key_protection !== $ref){
    get_template_part("404");
    exit;
   }
}
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl" data-nav-layout="vertical" data-theme-mode="light" data-header-styles="light"
    data-menu-styles="dark" data-toggled="close">

<head>

    <!-- Meta Data -->
    <meta charset="UTF-8">
    <meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=no'>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title> <?= get_the_title() ?> </title>
    <meta name="Description" content="Bootstrap Responsive Admin Web Dashboard HTML5 Template">
    <meta name="Author" content="Spruko Technologies Private Limited">
    <meta name="keywords"
        content="admin,admin dashboard,admin panel,admin template,bootstrap,clean,dashboard,flat,jquery,modern,responsive,premium admin templates,responsive admin,ui,ui kit.">

    <!-- Favicon -->
    <?php if (function_exists('get_site_icon_url') && has_site_icon()) : ?>
    <link rel="icon" href="<?php echo esc_url(get_site_icon_url()); ?>" type="image/png">
    <?php endif; ?>

    <script
        src="<?php echo get_template_directory_uri(); ?>/assets/libs/choices.js/public/assets/scripts/choices.min.js">
    </script>

    <!-- Bootstrap Css -->
    <link id="style" href="<?php echo get_template_directory_uri(); ?>/assets/libs/bootstrap/css/bootstrap.min.css"
        rel="stylesheet">

    <!-- Style Css -->
    <link href="<?php echo get_template_directory_uri(); ?>/style.css" rel="stylesheet">

    <!-- Icons Css -->
    <link href="<?php echo get_template_directory_uri(); ?>/assets/css/icons.css" rel="stylesheet">


    <!-- Choices Css -->
    <link rel="stylesheet"
        href="<?php echo get_template_directory_uri(); ?>/assets/libs/choices.js/public/assets/styles/choices.min.css">


    <!-- Custom Css -->
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/custom.css">

    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/libs/swiper/swiper-bundle.min.css">
    <!-- Sweetalerts CSS -->

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>

<body class="error-1">


    <div class="page main-signin-wrapper">
        <?php
        include 'actions/action-users.php';
        if (!empty($messages)) {
            echo "
            <script>
            document.addEventListener('DOMContentLoaded', function() {
                document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                document.body.classList.add('swal-open'); 
                Swal.fire({
                icon: 'error',
                title: 'خطا!',
                html: 'نام کاربری یا رمز ',
                confirmButtonText: 'متوجه شدم',
                allowOutsideClick: false,
                allowEscapeKey: false,
                didOpen: () => {
                    document.querySelector('.swal2-container').classList.add('swal-active');
                },
                willClose: () => {
                    document.body.classList.remove('swal-open');
                    document.querySelector('.swal-overlay').remove();
                },
                });
            });
            </script>
            ";
        }
        ?>
        <!-- Start::row-1 -->
        <div class="row signpages">
            <div class="col-md-12">
                <div class="card">
                    <div class="row row-sm">
                        <div class="col-lg-12 col-xl-12 col-xs-12 col-sm-12 login_form ">
                            <div class="main-container container-fluid">
                                <div class="row row-sm">
                                    <div class="card-body">
                                        <div class="clearfix"></div>
                                        <h3 class=" mb-2 titr_rigester">ثبت نام</h3>
                                        <div class="card-body" style="border-bottom: 1px solid #cfcfcf; padding:20px">
                                            <form class="row g-3 mt-0 new-user" action="" method="post"
                                                enctype="multipart/form-data">
                                                <input type="text" name="key_protection" hidden class="form-control"
                                                    value="<?php echo md5(time()) ?>">
                                                <?php if(isset($ref)){ ?>
                                                    <input type="hidden" name="parent_id" value="<?= $key->id ?>">
                                                <?php } ?>
                                                <div class="col-md-4">
                                                    <label class="form-label">نام و نام خانوادگی<span
                                                            class="required">*</span></label>
                                                    <input type="text" name="fl_name" class="form-control"
                                                        placeholder="نام و نام خانوادگی را وارد نمایید"
                                                        value="<?= old('fl_name') ?>">
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="form-label">کد ملی<span
                                                            class="required">*</span></label>
                                                    <input type="text" name="postal_code"
                                                        class="form-control postal-code"
                                                        placeholder="کد ملی خود را وارد نمایید"
                                                        value="<?= old('postal_code') ?>">
                                                </div>
                                                <div class="col-md-4">
                                                    <label for="phone_number" class="form-label">شماره همراه<span
                                                            class="required">*</span></label>
                                                    <div class="input-group">
                                                        <input type="text" name="phone"
                                                            class="form-control phone_number nofarsi"
                                                            value="<?= old('phone') ?>"
                                                            placeholder="شماره همراه را وارد نمایید">
                                                        <span class="input-group-text login-register">
                                                            98+
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class=" col-md-4">
                                                    <label class="form-label">ایمیل<span
                                                            class="required">*</span></label>
                                                    <input type="email" name="email" class="form-control nofarsi"
                                                        placeholder="ایمیل را وارد نمایید" value="<?= old('email') ?>">
                                                </div>
                                                <div class=" col-md-4">
                                                    <label class="form-label">نام کاربری<span
                                                            class="required">*</span></label>
                                                    <input type="text" name="username" class="form-control nofarsi"
                                                        placeholder="نام کاربری را وارد نمایید"
                                                        value="<?= old('username') ?>">
                                                </div>
                                                <div class="col-md-4">
                                                    <label for="inputPassword" class="form-label">رمز عبور<span
                                                            class="required">*</span></label>
                                                    <div class="input-group">
                                                        <input type="password" name="password"
                                                            class="form-control inputPassword nofarsi"
                                                            placeholder="رمز عبور را وارد نمایید">
                                                        <span class="input-group-text togglePassword login-register"
                                                            style="cursor: pointer;">
                                                            <i class="fas fa-eye"></i>
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="form-label">استان<span
                                                            class="required">*</span></label>
                                                    <input type="text" name="province" class="form-control onlyfarsi"
                                                        placeholder="استان را وارد نمایید"
                                                        value="<?= old('province') ?>">
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="form-label">شهر<span class="required">*</span></label>
                                                    <input type="text" name="city" class="form-control onlyfarsi"
                                                        placeholder="شهر را وارد نمایید" value="<?= old('city') ?>">
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="form-label">کد پستی<span
                                                            class="required">*</span></label>
                                                    <input type="text" maxlength="10" name="zipcode"
                                                        class="form-control zipcode"
                                                        placeholder="کد پستی را وارد نمایید"
                                                        value="<?= old('zipcode') ?>">
                                                </div>
                                                <div class="col-md-12">
                                                    <label class="form-label">آدرس کامل<span
                                                            class="required">*</span></label>
                                                    <textarea name="address"
                                                        placeholder="آدرس را به صورت کامل وارد نمایید"
                                                        class="form-control onlyfarsi address"><?= old('address') ?></textarea>
                                                </div>
                                                <div class="col-md-6">
                                                    <label for="inputState" class="form-label">مدرک تحصیلی<span
                                                            class="required">*</span></label>
                                                    <select name="madrak" id="inputState"
                                                        class="form-select form-select-lg">
                                                        <option value="diploma"
                                                            <?= old('madrak') === 'diploma' ? 'selected' : '' ?>>دیپلم
                                                        </option>
                                                        <option value="associate"
                                                            <?= old('madrak') === 'associate' ? 'selected' : '' ?>>
                                                            کاردانی</option>
                                                        <option value="bachelor"
                                                            <?= old('madrak') === 'bachelor' ? 'selected' : '' ?>>
                                                            کارشناسی</option>
                                                        <option value="master"
                                                            <?= old('madrak') === 'master' ? 'selected' : '' ?>>کارشناسی
                                                            ارشد</option>
                                                        <option value="phd"
                                                            <?= old('madrak') === 'phd' ? 'selected' : '' ?>>دکترا
                                                        </option>
                                                    </select>
                                                </div>
                                                <div class="col-md-6">
                                                    <label for="inputState" class="form-label">نقش کاربری<span
                                                            class="required">*</span></label>
                                                    <select name="user_role" id="inputState"
                                                        class="form-select form-select-lg">
                                                        <?php $exsit = exsit_admin();
                                                        if($exsit <=0){
                                                        ?>
                                                        <option value="admin_site"
                                                            <?= old('user_role') === 'admin_site' ? 'selected' : '' ?>>
                                                            مدیر سایت</option>
                                                        <?php } elseif(isset($ref)){?>
                                                        <option value="representative"
                                                            <?= old('user_role') === 'representative' ? 'selected' : '' ?>>
                                                            نماینده</option>
                                                        <?php }else{ ?>
                                                        <option value="regional_manager"
                                                            <?= old('user_role') === 'regional_manager' ? 'selected' : '' ?>>
                                                            مدیر منطقه</option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                                <div class="col-12">
                                                    <label for="imgeUpload" class="form-label">تصویر پروفایل</label>
                                                    <input type="file" name="profile" id="imageUpload"
                                                        class="form-control">
                                                    <div class="container-preview text-center img-fluid">
                                                        <img id="preview" src="" class="mt-2 img-prev">
                                                    </div>
                                                </div>
                                                <div class="col-12 text-center">
                                                    <button type="submit" name="register-user"
                                                        class="btn btn-success btn-lg text">ثبت
                                                        کاربر</button>
                                                </div>
                                            </form>
                                        </div>
                                        <div class=" mt-3 ms-0">
                                            <p class="mb-0">آیا از قبل اکانت داشتید؟ <a
                                                    href="<?= site_url('login') ?>">وارد شوید</a></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- End::row-1 -->

    </div>

    <!-- Custom-Switcher JS -->
    <script src="<?= get_template_directory_uri() ?>/assets/js/custom-switcher.min.js"></script>

    <!-- Bootstrap JS -->
    <script src="<?= get_template_directory_uri() ?>/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Custom JS -->
    <script src="<?php echo get_template_directory_uri(); ?>/assets/js/custom.js" defer></script>
    <script src="<?php echo get_template_directory_uri(); ?>/assets/js/script.js" defer></script>

</body>

</html>