<?php
/*
Template Name: پروفایل
*/
include "actions/action-users.php";
?>
<?php get_header();
get_sidebar();
?>

<!-- Start::app-content -->
<div class="main-content app-content">
    <div class="container-fluid">

        <!-- Page Header -->

        <div class="d-md-flex d-block align-items-center justify-content-between page-header-breadcrumb">
            <div>
                <h2 class="main-content-title fs-24 mb-1">پروفایل</h2>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">صفحه ها</a></li>
                    <li class="breadcrumb-item active" aria-current="page">پروفایل</li>
                </ol>
            </div>

        </div>

        <!-- Page Header Close -->
        <?php 
        $user_info = $_SESSION['user_info'];
        $row = get_result_id("custom_users", custom_session_id());
         ?>
        <!-- Start:: row-1 -->
        <div class="row row-sm">
            <div class="col-lg-12 col-md-12">
                <div class="card custom-card">
                    <div class="card-body">
                        <div class="panel profile-cover" style="position: relative;">
                            <div class="profile-cover__img">
                                <img class="img-fluid"
                                    src="<?= $row->profile ? $row->profile : get_template_directory_uri() . '/assets/images/profile/defualt.jpg' ?>"
                                    alt="img">
                                <span class="name_user">
                                    <h3 class="h3"><?= $user_info['fl_name'] ?></h3>
                                </span>
                            </div>
                        </div>
                        <div class="profile-tab tab-menu-heading">
                                <nav class="nav main-nav-line p-3 tabs-menu profile-nav-line">
                                    <a class="nav-link  active" data-bs-toggle="tab" href="#show_info">نمایش اطلاعات</a>
                                    <a class="nav-link" data-bs-toggle="tab" href="#edit_info">ویرایش اطلاعات</a>
                                    <a class="nav-link" data-bs-toggle="tab" href="#account-setting">تنظیم رمز عبور</a>
                                </nav>
                            </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End:: row-1 -->
        <!-- Start:: row-2 -->
        <div class="row row-sm">
            <div class="col-lg-12 col-md-12">
                <div class="card custom-card main-content-body-profile">
                    <div class="tab-content">
                        <div class="main-content-body tab-pane p-4 border-top-0 active" id="show_info">
                            <div class=" rounded-10">
                                <div class="p-4 profile_info" style="text-align: justify;">
                                    <div class="row" style="font-size: 20px;">
                                        <div class="col-xl-6 col-xs-12 custom_profile_info">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="25" height="25"
                                                viewBox="0 0 448 512">
                                                <!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.-->
                                                <path
                                                    d="M304 128a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM96 128a128 128 0 1 1 256 0A128 128 0 1 1 96 128zM49.3 464l349.5 0c-8.9-63.3-63.3-112-129-112l-91.4 0c-65.7 0-120.1 48.7-129 112zM0 482.3C0 383.8 79.8 304 178.3 304l91.4 0C368.2 304 448 383.8 448 482.3c0 16.4-13.3 29.7-29.7 29.7L29.7 512C13.3 512 0 498.7 0 482.3z" />
                                            </svg>
                                            نام و نام خانوادگی :
                                            <?= $user_info['fl_name'] ?>
                                        </div>
                                        <div class="col-xl-6 col-xs-12 custom_profile_info">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="25" height="25"
                                                viewBox="0 0 576 512">
                                                <!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.-->
                                                <path
                                                    d="M512 80c8.8 0 16 7.2 16 16l0 320c0 8.8-7.2 16-16 16L64 432c-8.8 0-16-7.2-16-16L48 96c0-8.8 7.2-16 16-16l448 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM208 256a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm-32 32c-44.2 0-80 35.8-80 80c0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16c0-44.2-35.8-80-80-80l-64 0zM376 144c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0zm0 96c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0z" />
                                            </svg>
                                            کد ملی : <?= $user_info['postal_code'] ?>
                                        </div>
                                        <div class="col-xl-6 col-xs-12 custom_profile_info">
                                            <i class="fa-regular fa-phone icon_profile"></i>
                                            شماره تماس : <?= $user_info['phone'] ?>
                                        </div>
                                        <div class="col-xl-6 col-xs-12 custom_profile_info">
                                            <i class="fa-regular fa-wreath-laurel icon_profile"></i>
                                            نقش کاربری :
                                            <?php switch ($user_info['user_role']) {
                                                case 'admin_site':
                                                    echo 'مدیر سایت';
                                                    break;
                                                case 'admin':
                                                    echo 'مدیر کل';
                                                    break;
                                                case 'regional_manager':
                                                    echo 'مدیر منطقه';
                                                    break;
                                                case 'representative':
                                                    echo 'نماینده';
                                                    break;
                                            } ?>
                                        </div>
                                        <div class="col-xl-6 col-xs-12 custom_profile_info">
                                            <i class="fa-regular fa-at icon_profile"></i>
                                            ایمیل : <?= $user_info['email'] ?>
                                        </div>
                                        <div class="col-xl-6 col-xs-12 custom_profile_info">
                                            <i class="fa-regular fa-circle-user icon_profile"></i>
                                            نام کاربری : <?= $user_info['username'] ?>
                                        </div>
                                        <div class="col-xl-6 col-xs-12 custom_profile_info">
                                            <i class="fa-regular fa-graduation-cap icon_profile"></i>
                                            مدرک تحصیلی :
                                            <?php switch ($user_info['madrak']) {
                                                case 'diploma':
                                                    echo 'دیپلم';
                                                    break;
                                                case 'associate':
                                                    echo 'کاردانی';
                                                    break;
                                                case 'bachelor':
                                                    echo 'کارشناسی';
                                                    break;
                                                case 'master':
                                                    echo 'کارشناسی ارشد';
                                                    break;
                                                case 'phd':
                                                    echo 'دکترا';
                                                    break;
                                            } ?>
                                        </div>
                                        <div class="col-xl-6 col-xs-12 custom_profile_info">
                                            <i class="fa-regular fa-signs-post icon_profile"></i>
                                            استان : <?= $user_info['province'] ?>
                                        </div>
                                        <div class="col-xl-6 col-xs-12 custom_profile_info">
                                            <i class="fa-regular fa-house-building icon_profile"></i>
                                            شهر : <?= $user_info['city'] ?>
                                        </div>
                                        <div class="col-xl-6 col-xs-12 custom_profile_info">
                                            <i class="fa-regular fa-location-dot icon_profile"></i>
                                            آدرس : <?= $user_info['address'] ?>
                                        </div>
                                        <div class="col-xl-6 col-xs-12 custom_profile_info">
                                            <i class="fa-regular fa-mailbox icon_profile"></i>
                                            کد پستی : <?= $user_info['zipcode'] ?>
                                        </div>
                                    </div>
                                </div>
                            </div>



                        </div>
                        <div class="main-content-body tab-pane p-4 border-top-0" id="edit_info">
                            <form class="row g-3 mt-0 new-user" action="" method="post" enctype="multipart/form-data">
                                <input type="text" name="key_protection" hidden class="form-control"
                                    value="<?= $row->key_protection ?>">
                                <div class="col-md-4">
                                    <label class="form-label">نام و نام خانوادگی<span class="required">*</span></label>
                                    <input type="text" name="fl_name" class="form-control"
                                        placeholder="نام و نام خانوادگی را وارد نمایید" value="<?= $row->fl_name ?>">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">کد ملی<span class="required">*</span></label>
                                    <input type="text" name="postal_code" class="form-control postal-code"
                                        placeholder="کد ملی را وارد نمایید" value="<?= $row->postal_code ?>">
                                </div>
                                <div class="col-md-4">
                                    <label for="inputPassword" class="form-label">شماره همراه<span
                                            class="required">*</span></label>
                                    <div class="input-group">
                                        <input type="text" name="phone" class="form-control phone_number nofarsi"
                                            value="<?= $row->phone ?>" placeholder="شماره همراه را وارد نمایید">
                                        <span class="input-group-text">
                                            98+
                                        </span>
                                    </div>
                                </div>
                                <div class=" col-md-4">
                                    <label class="form-label">ایمیل<span class="required">*</span></label>
                                    <input type="email" name="email" class="form-control nofarsi"
                                        placeholder="ایمیل را وارد نمایید" value="<?= $row->email ?>">
                                </div>
                                <div class=" col-md-4">
                                    <label class="form-label">نام کاربری<span class="required">*</span></label>
                                    <input type="text" name="username" class="form-control nofarsi"
                                        placeholder="نام کاربری را وارد نمایید" value="<?= $row->username ?>">
                                </div>
                                <div class="col-md-4">
                                    <label for="inputPassword" class="form-label">رمز عبور<span
                                            class="required">*</span></label>
                                    <div class="input-group">
                                        <input type="password" name="password"
                                            class="form-control inputPassword nofarsi"
                                            placeholder="رمز عبور را وارد نمایید">
                                        <span class="input-group-text togglePassword" style="cursor: pointer;">
                                            <i class="fas fa-eye"></i>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">استان<span class="required">*</span></label>
                                    <input type="text" name="province" class="form-control onlyfarsi"
                                        placeholder="استان را وارد نمایید" value="<?= $row->province ?>">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">شهر<span class="required">*</span></label>
                                    <input type="text" name="city" class="form-control onlyfarsi"
                                        placeholder="شهر را وارد نمایید" value="<?= $row->city ?>">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">کد پستی<span class="required">*</span></label>
                                    <input type="text" maxlength="10" name="zipcode" class="form-control zipcode"
                                        placeholder="کد پستی را وارد نمایید" value="<?= $row->zipcode ?>">
                                </div>
                                <div class="col-md-12">
                                    <label class="form-label">آدرس کامل<span class="required">*</span></label>
                                    <textarea name="address" placeholder="آدرس را به صورت کامل وارد نمایید"
                                        class="form-control address onlyfarsi"><?= $row->address ?></textarea>
                                </div>
                                <div class="col-md-6">
                                    <label for="inputState" class="form-label">مدرک تحصیلی<span
                                            class="required">*</span></label>
                                    <select name="madrak" id="inputState" class="form-select form-select-lg">
                                        <option value="diploma" <?= $row->madrak === 'diploma' ? 'selected' : '' ?>>
                                            دیپلم
                                        </option>
                                        <option value="associate" <?= $row->madrak === 'associate' ? 'selected' : '' ?>>
                                            کاردانی</option>
                                        <option value="bachelor" <?= $row->madrak === 'bachelor' ? 'selected' : '' ?>>
                                            کارشناسی</option>
                                        <option value="master" <?= $row->madrak === 'master' ? 'selected' : '' ?>>
                                            کارشناسی
                                            ارشد</option>
                                        <option value="phd" <?= $row->madrak === 'phd' ? 'selected' : '' ?>>دکترا
                                        </option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label for="inputState" class="form-label">نقش کاربری<span
                                            class="required">*</span></label>
                                    <select name="user_role" id="inputState" class="form-select form-select-lg">
                                        <?php if ($user_info['user_role'] === 'admin_site' && $user_info['key_protection'] == $row->key_protection) { ?>
                                        <option value="admin_site"
                                            <?= $row->user_role === 'admin_site' ? 'selected' : '' ?>> مدیر سایت
                                        </option>
                                        <?php  } elseif ($user_info['user_role'] === 'admin' && $user_info['key_protection'] == $row->key_protection) { ?>
                                        <option value="admin" <?= $row->user_role === 'admin' ? 'selected' : '' ?>> مدیر
                                            کل
                                        </option>
                                        <?php } elseif ($user_info['user_role'] === 'regional_manager') { ?>
                                        <?php if ($row->user_role === 'regional_manager') { ?>
                                        <option value="regional_manager"
                                            <?= $row->user_role === 'regional_manager' ? 'selected' : '' ?>>مدیر منطقه
                                        </option>
                                        <?php } else { ?>
                                        <option value="representative"
                                            <?= $row->user_role === 'representative' ? 'selected' : '' ?>>نماینده
                                        </option>
                                        <?php } ?>
                                        <?php } elseif ($user_info['user_role'] === 'admin_site') { ?>
                                        <option value="admin_site"
                                            <?= $row->user_role === 'admin_site' ? 'selected' : '' ?>>مدیر سایت</option>
                                        <option value="admin" <?= $row->user_role === 'admin' ? 'selected' : '' ?>>مدیر
                                            کل
                                        </option>
                                        <option value="regional_manager"
                                            <?= $row->user_role === 'regional_manager' ? 'selected' : '' ?>>مدیر منطقه
                                        </option>
                                        <?php } elseif ($user_info['user_role'] === 'admin') { ?>
                                        <option value="admin" <?= $row->user_role === 'admin' ? 'selected' : '' ?>>مدیر
                                            کل
                                        </option>
                                        <option value="regional_manager"
                                            <?= $row->user_role === 'regional_manager' ? 'selected' : '' ?>>مدیر منطقه
                                        </option>

                                        <?php } ?>
                                        <?php if ($user_info['user_role'] === 'representative') { ?>
                                        <option value="representative"
                                            <?= $row->user_role === 'representative' ? 'selected' : '' ?>> نماینده
                                        </option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="col-12">
                                    <label for="imgeUpload" class="form-label">تصویر پروفایل</label>
                                    <input type="file" name="profile" id="imageUpload" class="form-control">
                                    <div class="container-preview text-center img-fluid">
                                        <img id="preview" class="mt-2 img-prev" style="display: block;"
                                            src="<?= $row->profile ?>">
                                    </div>
                                </div>
                                <div class="col-12 text-center">
                                    <button type="submit" name="update-user" class="btn btn-success btn-lg text">بروز
                                        رسانی
                                        کاربر</button>
                                </div>
                            </form>
                        </div>
                        <div class="main-content-body p-4 border tab-pane border-top-0" id="account-setting">
                            <div class="card-body border">
                                <div class="mb-4 main-content-label">تغییر رمز</div>
                                <form class="" action="" method="post">
                                    <div class="form-group ">
                                        <div class="row row-sm">
                                            <div class="col-md-3">
                                                <label class="form-label">ثبت / تغییر رمز عبور<span
                                                        class="required">*</span></label>
                                            </div>
                                            <div class="col-md-9">
                                                <input type="password" name="password"
                                                    class="form-control inputPassword nofarsi"
                                                    placeholder="رمز عبور خود را وارد نمایید" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="text-center">
                                        <button type="submit" name="change_password"
                                            class="btn btn-primary btn-lg text">تغییر رمز عبور</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End:: row-2 -->

    </div>
</div>
<!-- End::app-content -->

<!-- Footer Start -->
<?php include 'footer.php' ?>
<!-- Footer End -->