<?php
/*
Template Name: نمایش اعلان ها
*/
check_access();
if (isset($_GET['notification_id']) || !empty($_GET['notification_id'])) {
    mark_notification_as_seen($_GET['notification_id']);
    $id = $_GET['notification_id'];
    $table = "custom_notifications";
    $row = get_notification_id($id);
    if (!$row || $row->id != $id) {
        get_template_part('404');
        exit;
    }
    // Set the dynamic title
    add_filter('wp_title', function ($title) use ($row) {
        return ' مشاهده اعلان ' . "($row->title)";
    });

    add_filter('the_title', function ($title) use ($row) {
        return ' مشاهده اعلان ' . "($row->title)";
    });
} else {
    mark_all_notifications_as_seen();
    echo "<title>مشاهده ی تمامی اعلان ها</title>";
}
get_header();
get_sidebar();
?>

<!-- Start::app-content -->
<div class="main-content app-content">
    <div class="container-fluid">

        <!-- Page Header -->

        <div class="d-md-flex d-block align-items-center justify-content-between page-header-breadcrumb">
            <div>
                <h2 class="main-content-title fs-24 mb-1"><?php if (isset($_GET['notification_id'])) {  ?>
                    مشاهده اعلان <?= $row->title ?>
                    <?php } else { ?>
                    مشاهده تمام اعلان ها
                    <?php } ?>
                </h2>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">اعلان ها</a></li>
                    <li class="breadcrumb-item active" aria-current="page">
                        <?php if (isset($_GET['notification_id'])) {  ?>
                        مشاهده اعلان <?= $row->title ?>
                        <?php } else { ?>
                        مشاهده تمام اعلان ها
                        <?php } ?></li>
                </ol>
            </div>
        </div>

        <!-- Page Header Close -->

        <!-- Start::container -->
        <div class="container">
            <ul class="notification">
                <?php if (isset($_GET['notification_id'])) { ?>
                    <li>
                    <div class="notification-time">
                        <?php $date_parts = get_persian_date_parts($row->created_at); ?>
                        <span class="date"><?= $date_parts['smart'] ?></span>
                        <span class="time"><?= $date_parts['time'] ?></span>
                    </div>
                    <div class="notification-icon">
                        <a href="javascript:void(0);"></a>
                    </div>
                    <div class="notification-time-date mb-2 d-block d-md-none">
                    <?php $date_parts = get_persian_date_parts($row->created_at); ?>
                        <span class="date"><?= $date_parts['smart'] ?></span>
                        <span class="time"><?= $date_parts['time'] ?></span>
                    </div>
                    <div class="notification-body">
                        <div class="media mt-0">
                            <div class=" avatar-md">
                                <img alt="avatar" class="rounded-6" src="<?= $row->profile ?>">
                            </div>
                            <div class="media-body ms-3 d-flex">
                                <div class="">
                                    <p class="tx-14 text-dark mb-0 tx-semibold"><?= esc_html($row->sender_name) ?></p>
                                    <p class="mb-0 tx-13 text-muted"><?= esc_html($row->description) ?></p>
                                </div>
                                <div class="notify-time">
                                    <p class="mb-0 text-muted tx-11"><?= $date_parts['relative'] ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </li>
                <?php } else {
                    $data = notifications_list('1', "10", custom_session_id());
                    $results = $data['results'];
                    if (empty($results)) {
                        echo '<span class="text-center" style="font-size:20px">هیچ اعلان جدیدی وجود ندارد</span>';
                    }
                    $total_pages = $data['total_pages'];
                    foreach ($results as $res): ?>
                <li>
                    <div class="notification-time">
                        <?php $date_parts = get_persian_date_parts($res->created_at); ?>
                        <span class="date"><?= $date_parts['smart'] ?></span>
                        <span class="time"><?= $date_parts['time'] ?></span>
                    </div>
                    <div class="notification-icon">
                        <a href="javascript:void(0);"></a>
                    </div>
                    <div class="notification-time-date mb-2 d-block d-md-none">
                    <?php $date_parts = get_persian_date_parts($res->created_at); ?>
                        <span class="date"><?= $date_parts['smart'] ?></span>
                        <span class="time"><?= $date_parts['time'] ?></span>
                    </div>
                    <div class="notification-body">
                        <div class="media mt-0">
                            <div class=" avatar-md">
                                <img alt="avatar" class="rounded-6" src="<?= $res->profile ?>">
                            </div>
                            <div class="media-body ms-3 d-flex">
                                <div class="">
                                    <p class="tx-14 text-dark mb-0 tx-semibold"><?= esc_html($res->sender_name) ?></p>
                                    <p class="mb-0 tx-13 text-muted"><?= esc_html($res->description) ?></p>
                                </div>
                                <div class="notify-time">
                                    <p class="mb-0 text-muted tx-11"><?= $date_parts['relative'] ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </li>
                <?php endforeach ?>
                <?php } ?>
            </ul>
            <div class="text-center mb-4">
              <?php if(!isset($_GET['notification_id'])){ ?>
                 <!-- Pagination -->
               <nav aria-label="Page navigation">
                        <ul class="pagination justify-content-center">
                            <?php
                                $pagination_links = paginate_links([
                                    'total' => $total_pages,
                                    'current' => $paged,
                                    'format' => '?paged=%#%',
                                    'show_all' => false,
                                    'type' => 'array',
                                    'end_size' => 1,
                                    'mid_size' => 2,
                                    'prev_next' => true,
                                    'prev_text' => __('قبلی'),
                                    'next_text' => __('بعدی'),
                                    'add_args' => false,
                                    'add_fragment' => '',
                                ]);

                                if ($pagination_links) {
                                    foreach ($pagination_links as $link) {
                                        $active_class = (strpos($link, 'current') !== false) ? 'active' : '';
                                        echo '<li class="page-item ' . $active_class . '">' . str_replace('page-numbers', 'page-link', $link) . '</li>';
                                    }
                                }
                                ?>
                        </ul>
                    </nav>
                    <!-- End Pagination -->
                <?php } ?>
            </div>
        </div>
        <!--End::container -->

    </div>
</div>
<!-- End::app-content -->

<?php get_footer(); ?>