<?php 
/*
Template Name: ایجاد کاربر جدید
*/
if(isset($_SESSION['user_info'])){
    $user_info = $_SESSION['user_info'];
}
check_access();
get_header();
get_sidebar();
?>

<!-- Start::app-content -->
<div class="main-content app-content">
    <div class="container-fluid">

        <!-- Page Header -->

        <div class="d-md-flex d-block align-items-center justify-content-between page-header-breadcrumb">
            <div>
                <h2 class="main-content-title fs-24 mb-1">ایجاد کاربر جدید</h2>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">کاربران</a></li>
                    <li class="breadcrumb-item active" aria-current="page">ایجاد کاربر جدید</li>
                </ol>
            </div>

        </div>

        <!-- Page Header Close -->

        <?php
        include 'actions/action-users.php';
        if (!empty($messages)) {
            echo "
            <script>
            document.addEventListener('DOMContentLoaded', function() {
                document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                document.body.classList.add('swal-open'); 
                Swal.fire({
                icon: 'error',
                title: 'خطا!',
                html: '$message',
                confirmButtonText: 'متوجه شدم',
                allowOutsideClick: false,
                allowEscapeKey: false,
                didOpen: () => {
                    document.querySelector('.swal2-container').classList.add('swal-active');
                },
                willClose: () => {
                    document.body.classList.remove('swal-open');
                    document.querySelector('.swal-overlay').remove();
                },
                });
            });
            </script>
            ";
        }
        ?>

        <!-- Start:: row-1 -->
        <div class="row row-sm">
            <div class="col-xl-9" style="margin: 0 auto;">
                <div class="card custom-card">
                    <div class="card-header custom-card-header justify-content-between">
                        <div class="card-title">
                            <i class="fa-classic fa-light fa-user custom-icon"></i>
                            ایجاد کاربر جدید
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="row g-3 mt-0 new-user" action="" method="post" enctype="multipart/form-data">
                            <input type="text" name="key_protection" hidden class="form-control"
                                value="<?php echo md5(time()) ?>">
                                <input type="text" class="form-control" name="parent_id" value="<?= $user_info['user_role'] == "regional_manager" ? $user_info['id'] : '0' ?>" hidden>
                                <div class="col-md-4">
                                <label class="form-label">نام و نام خانوادگی<span class="required">*</span></label>
                                <input type="text" name="fl_name" class="form-control"
                                    placeholder="نام و نام خانوادگی را وارد نمایید" value="<?= old('fl_name') ?>">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">کد ملی<span class="required">*</span></label>
                                <input type="text" name="postal_code" class="form-control postal-code"
                                    placeholder="کد ملی خود را وارد نمایید" value="<?= old('postal_code') ?>">
                            </div>
                            <div class="col-md-4">
                                <label for="inputPassword" class="form-label">شماره همراه<span class="required">*</span></label>
                                <div class="input-group">
                                    <input type="text" name="phone" class="form-control phone_number nofarsi" placeholder="شماره همراه را وارد نمایید">
                                    <span class="input-group-text">
                                        98+
                                    </span>
                                </div>
                            </div>
                            <div class=" col-md-4">
                                <label class="form-label">ایمیل<span class="required">*</span></label>
                                <input type="email" name="email" class="form-control nofarsi"
                                    placeholder="ایمیل را وارد نمایید" value="<?= old('email') ?>">
                            </div>
                            <div class=" col-md-4">
                                <label class="form-label">نام کاربری<span class="required">*</span></label>
                                <input type="text" name="username" class="form-control nofarsi"
                                    placeholder="نام کاربری را وارد نمایید" value="<?= old('username') ?>">
                            </div>
                            <div class="col-md-4">
                                <label for="inputPassword" class="form-label">رمز عبور<span class="required">*</span></label>
                                <div class="input-group">
                                    <input type="password" name="password" class="form-control inputPassword nofarsi" placeholder="رمز عبور را وارد نمایید">
                                    <span class="input-group-text togglePassword" style="cursor: pointer;">
                                        <i class="fas fa-eye"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">استان<span class="required">*</span></label>
                                <input type="text" name="province" class="form-control onlyfarsi"
                                    placeholder="استان را وارد نمایید" value="<?= old('province') ?>">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">شهر<span class="required">*</span></label>
                                <input type="text" name="city" class="form-control onlyfarsi"
                                    placeholder="شهر را وارد نمایید" value="<?= old('city') ?>">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">کد پستی<span class="required">*</span></label>
                                <input type="text" maxlength="10" name="zipcode" class="form-control zipcode"
                                    placeholder="کد پستی را وارد نمایید" value="<?= old('zipcode') ?>">
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">آدرس کامل<span class="required">*</span></label>
                                <textarea name="address" placeholder="آدرس را به صورت کامل وارد نمایید" class="form-control address onlyfarsi"><?= old('address') ?></textarea>
                            </div>
                            <div class="col-md-6">
                                <label for="inputState" class="form-label">مدرک تحصیلی<span class="required">*</span></label>
                                <select name="madrak" id="inputState" class="form-select form-select-lg">
                                    <option value="diploma" <?= old('madrak') === 'diploma' ? 'selected' : '' ?> >دیپلم</option>
                                    <option value="associate" <?= old('madrak') === 'associate' ? 'selected' : '' ?>>کاردانی</option>
                                    <option value="bachelor" <?= old('madrak') === 'bachelor' ? 'selected' : '' ?>>کارشناسی</option>
                                    <option value="master" <?= old('madrak') === 'master' ? 'selected' : '' ?>>کارشناسی ارشد</option>
                                    <option value="phd" <?= old('madrak') === 'phd' ? 'selected' : '' ?>>دکترا</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="inputState" class="form-label">نقش کاربری<span class="required">*</span></label>
                                <select name="user_role" id="inputState" class="form-select form-select-lg">
                                    <?php if($user_info['user_role'] === 'regional_manager') { ?>
                                    <option value="representative" <?= old('user_role') === 'representative' ? 'selected' : '' ?>>نماینده</option>
                                        <?php } elseif($user_info['user_role'] === 'admin_site'){ ?>
                                    <option value="admin" <?= old('user_role') === 'admin' ? 'selected' : '' ?>>مدیر کل</option>
                                    <option value="regional_manager" <?= old('user_role') === 'regional_manager' ? 'selected' : '' ?>>مدیر منطقه</option>
                                    <?php } elseif($user_info['user_role'] === 'admin'){ ?>
                                    <option value="regional_manager" <?= old('user_role') === 'regional_manager' ? 'selected' : '' ?>>مدیر منطقه</option>
                                    <?php } ?>
                                </select>
                            </div>
                            <div class="col-12">
                                <label for="imgeUpload" class="form-label">تصویر پروفایل</label>
                                <input type="file" name="profile"  id="imageUpload" class="form-control">
                                <div class="container-preview text-center img-fluid">
                                    <img id="preview" src="" class="mt-2 img-prev">
                                </div>
                            </div>
                            <div class="col-12 text-center">
                                <button type="submit" name="save-user" class="btn btn-success btn-lg text">ثبت
                                    کاربر جدید</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- End:: row-1 -->
    </div>
</div>
<!-- End::app-content -->

<!-- Footer Start -->
<?php get_footer() ?>
<!-- Footer End -->
