<?php
/*
Template Name: ایجاد قسط جدید
*/
include 'actions/action-aghsat.php';
get_header();
get_sidebar();
?>

<!-- Start::app-content -->
<div class="main-content app-content">
    <div class="container-fluid">

        <!-- Page Header -->

        <div class="d-md-flex d-block align-items-center justify-content-between page-header-breadcrumb">
            <div>
                <h2 class="main-content-title fs-24 mb-1">ایحاد قسط جدید</h2>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">اقساط</a></li>
                    <li class="breadcrumb-item active" aria-current="page">ایجاد قسط جدید</li>
                </ol>
            </div>

        </div>

        <!-- Page Header Close -->
        <?php
        if (!empty($message)) {
            echo "
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                    document.body.classList.add('swal-open'); 
                    Swal.fire({
                        icon: 'error',
                        title: 'خطا!',
                        html: '$message',
                        confirmButtonText: 'متوجه شدم',
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        didOpen: () => {
                            document.querySelector('.swal2-container').classList.add('swal-active');
                        },
                        willClose: () => {
                            document.body.classList.remove('swal-open');
                            document.querySelector('.swal-overlay').remove();
                        },
                    });
                });
            </script>
            ";
        }
        ?>

        <!-- Start:: row-1 -->
        <div class="row row-sm">
            <div class="col-xl-9" style="margin: 0 auto;">
                <div class="card custom-card">
                    <div class="card-header custom-card-header justify-content-between">
                        <div class="card-title">
                            <i class="fa-light fa-tablet-rugged custom-icon"></i>
                            ایجاد قسط جدید
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="row g-3 mt-0 new-ghest" action="" method="post" enctype="multipart/form-data">
                            <input type="text" name="key_protection" hidden class="form-control"
                                value="<?php echo md5(time()) ?>">
                            <div class="col-md-6">
                                <label for="inputState" class="form-label">بانک ها</label>
                                <select name="bank_id" id="inputState" class="form-select form-select-lg">
                                    <?php $results = bank_results();
                                    if(!$results){
                                        echo '<option value="">هیچ بانک فعالی وجود ندارد</option>';
                                    }else{
                                        foreach ($results as $result):
                                    ?>
                                    <option value="<?= $result->id ?>" <?= old('bank_id') === $result->id ? 'selected' : '' ?>><?= $result->bank_name ?>
                                    </option>
                                    <?php
                                    endforeach;
                            } ?>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">مدت زمان قسط <sup>بر اساس ماه</sup><span
                                        class="required">*</span></label>
                                <input type="text" id="title_input" name="ghest_time" class="form-control ghest_time"
                                    placeholder="مدت زمان قسط را وارد نمایید" value="<?= old('ghest_time') ?>">
                            </div>
                            <div class=" col-md-6">
                                <label class="form-label">نامک قسط<span class="required">*</span></label>
                                <input type="text" id="slug_input" name="slug" class="form-control nofarsi"
                                    placeholder="نامک قسط را وارد نمایید" value="<?= old('slug') ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">درصد سود<span class="required">*</span></label>
                                <input type="text" name="sood" class="form-control sood"
                                    placeholder="درصد سود را وارد نمایید" value="<?= old('sood') ?>">
                            </div>
                            <div class="col-md-6">
                                <label for="inputState" class="form-label">وضعیت</label>
                                <select name="status" id="inputState" class="form-select form-select-lg">
                                    <option value="active" <?= old('status') === 'active' ? 'selcted' : '' ?>>فعال
                                    </option>
                                    <option value="deactive" <?= old('status') === 'deactive' ? 'selcted' : '' ?>>غیر
                                        فعال</option>
                                </select>
                            </div>
                            <div class="col-12 text-center">
                                <button type="submit" name="save-ghest" class="btn btn-primary btn-lg text">ثبت
                                    قسط جدید</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- End:: row-1 -->
    </div>
</div>
<!-- End::app-content -->

<!-- Footer Start -->
<?php get_footer() ?>
<!-- Footer End -->