<?php
/*
Template Name: مدیریت فاکتور ها
*/
include "actions/action_invoice.php";
include "actions/action_arrived.php";
echo '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>';
if (isset($_GET['action_delete']) && !empty($_GET['action_delete'])) {
    $transaction_id = $_GET["action_delete"];
    $delete = get_delete_invoice($transaction_id);
    if ($delete) {
        header("Location:" . site_url('manager_invoice/?delete=success'));
        exit;
    }
}
if (isset($_GET['delete']) && $_GET['delete'] == 'success') {
    echo "
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
            document.body.classList.add('swal-open'); 
            Swal.fire({
                icon: 'success',
                title: 'حذف موفقیت آمیز!',
                text: 'فاکتور با موفقیت حذف شد',
                confirmButtonText: 'متوجه شدم',
                timer: 5000,
                timerProgressBar: true,
                willClose: () => {
                            document.body.classList.remove('swal-open');
                            document.querySelector('.swal-overlay').remove();
                        },
            }).then(() => {
            // حذف کوئری استرینگ بدون رفرش صفحه
            const newUrl = window.location.origin + window.location.pathname;
            history.replaceState(null, '', newUrl);
        });
        });
    </script>
    ";
}
get_header();
get_sidebar();
?>

<!-- Start::app-content -->
<div class="main-content app-content">
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="d-md-flex d-block align-items-center justify-content-between page-header-breadcrumb">
            <div>
                <h2 class="main-content-title fs-24 mb-1">لیست فاکتور ها</h2>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item active"><a href="manager_invoice">فاکتور ها</a></li>
                </ol>
            </div>
        </div>
        <!-- Page Header Close -->

        <!-- Start::row-1 -->
        <div class="row">
            <div class="card custom-card">
                <div class="card-body">
                    <div class="row rows">
                        <div class="col-xl-4 searched">
                            <form action="" name="search" method="get" class="search-form">
                                <div class="input-group slector">
                                    <div class="input-group-btn search-panel" style="height: 40px;">
                                        <select class="js-example-basic-single" name="status" data-trigger>
                                            <option value="" hidden selected>انتخاب بر اساس</option>
                                            <option value="approved">تایید شده</option>
                                            <option value="pending">در انتظار تایید</option>
                                            <option value="rejected">رد شده</option>
                                        </select>
                                    </div>
                                    <input type="text" class="form-control" name="q" placeholder="جست و جو کنید..."
                                        autocomplete="off">
                                    <button type="submit" class="btn btn-primary"><i class="fe fe-search"
                                            aria-hidden="true"></i></button>
                                </div>
                            </form>
                        </div>
                    </div>

                    <?php
                    $paged = (get_query_var('paged')) ? absint(get_query_var('paged')) : 1;
                    $posts_per_page = 10;
                    $user_info = $_SESSION['user_info'];
                    $role = $user_info['user_role'];
                    $status = isset($_GET['status']) ? $_GET['status'] : '';
                    $q = isset($_GET['q']) ? $_GET['q'] : '';

                    $data = get_result_invoices('custom_invoices', $q, $status, $paged, $posts_per_page);
                    $results = $data['results'];
                    $total_pages = $data['total_pages'];
                    ?>
                    <?php

                    if (!empty($error)) {
                        echo "
<script>
document.addEventListener('DOMContentLoaded', function() {
document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
document.body.classList.add('swal-open'); 
Swal.fire({
    icon: 'error',
    title: 'خطا',
    html: '$error',
    confirmButtonText: 'متوجه شدم',
    allowOutsideClick: false,
    allowEscapeKey: false,
    didOpen: () => {
        document.querySelector('.swal2-container').classList.add('swal-active');
    },
    willClose: () => {
        document.body.classList.remove('swal-open');
        document.querySelector('.swal-overlay').remove();
    },
}).then(() => {
// حذف کوئری استرینگ بدون رفرش صفحه
const newUrl = window.location.origin + window.location.pathname;
history.replaceState(null, '', newUrl);
});
});
</script>
";
                    }

                    if (!empty($message)) {
                        echo "
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                    document.body.classList.add('swal-open'); 
                    Swal.fire({
                        icon: 'success',
                        title: 'موفقیت آمیز',
                        html: '$message',
                        confirmButtonText: 'متوجه شدم',
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        didOpen: () => {
                            document.querySelector('.swal2-container').classList.add('swal-active');
                        },
                        willClose: () => {
                            document.body.classList.remove('swal-open');
                            document.querySelector('.swal-overlay').remove();
                        },
                    }).then(() => {
            // حذف کوئری استرینگ بدون رفرش صفحه
            const newUrl = window.location.origin + window.location.pathname;
            history.replaceState(null, '', newUrl);
        });
                });
            </script>
            ";
                    }
                    ?>
                    <form action="" method="post">
                        <div class="table-responsive custom-scrollbar">
                            <table class="table text-nowrap table-bordered table-hover">
                                <thead class="head-users-table">
                                    <tr>
                                        <th>شماره فاکتور</th>
                                        <th>ایجاد شده توسط</th>
                                        <th> مبلغ فاکتور</th>
                                        <th>وضعیت</th>
                                        <th>عملیات های فاکتور</th>
                                        <th>تاریخ انتشار</th>
                                        <?php if ($role == "regional_manager") { ?>
                                        <th colspan="6">عملیات ها</th>
                                        <?php } elseif ($role == "representative") { ?>
                                        <th colspan="6">مدیریت تصویر رسید</th>
                                        <?php } ?>
                                        <?php  if ($role == "admin" || $role == "admin_site") { ?>
                                        <th colspan="6">مشاهده تصویر رسید</th>
                                        <?php } ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($results) : ?>
                                    <?php foreach ($results as $row) : ?>
                                    <tr>
                                        <td>
                                            <?= $row->transaction_id ?>
                                        </td>
                                        <td>
                                            <?php if ($role == "admin") { ?>
                                            <a
                                                href="edit-user?action_edit=<?= $row->user_key ?>  "><?= $row->user_name ?></a>
                                            <?php } else { ?>
                                            <?= $row->user_name ?>
                                            <?php } ?>
                                        </td>
                                        <td><?= number_format($row->total_price) ?> تومان </td>
                                        <td>
                                            <div class="text-center">
                                                <span class="alert 
                                                <?php
                                                switch ($row->status) {
                                                    case 'pending':
                                                        echo 'alert-warning';
                                                        break;
                                                    case 'rejected':
                                                        echo 'alert-danger';
                                                        break;
                                                    case 'approved':
                                                        echo 'alert-success';
                                                        break;
                                                    default:
                                                        echo 'alert-secondary';
                                                }
                                                ?>">
                                                    <?php
                                                            switch ($row->status) {
                                                                case 'pending':
                                                                    echo 'در انتظار تایید توسط مدیر کل';
                                                                    break;
                                                                case 'rejected':
                                                                    echo 'رد شده';
                                                                    break;
                                                                case 'approved':
                                                                    echo 'تایید شده';
                                                                    break;
                                                                default:
                                                                    echo 'نامشخص';
                                                            }
                                                            ?>
                                                </span>
                                            </div>
                                        </td>
                                        <td>
                                            <?php 
                                            $result = GetResultNotifRejected(custom_session_id());
                                            ?>
                                            <div class="text-center">
                                                <form action="" method="post">
                                                    <input type="hidden" name="transaction_id"
                                                        value="<?= $row->transaction_id ?>">
                                                    <input type="hidden" name="user_id" value="<?= $row->agent_id ?>">
                                                    <?php if ($role == "regional_manager") { ?>
                                                    <a data-tooltip="مشاهده" class="btn tooltip-icon btn_icon"
                                                        href="show_invoice?action_show=<?= $row->transaction_id ?>"><i
                                                            class="fa-regular fa-eye"></i></a>
                                                    <?php if ($row->status == "pending" || $row->status == "rejected") { ?>
                                                    <button type="submit" name="approved_btn"
                                                        data-tooltip="تایید فاکتور" class="btn tooltip-icon btn_icon"><i
                                                            class="fa-regular fa-check"></i></button>
                                                    <?php } ?>
                                                    <?php if ($row->status == "pending" || $row->status == "approved") { ?>
                                                    <button name="rejected_btn" data-tooltip="رد فاکتور"
                                                        class="btn tooltip-icon btn_icon"><i
                                                            class="fa-regular fa-circle-xmark"></i></button>
                                                    <?php } ?>
                                                    <?php if ($row->status == "approved" || $row->status == "rejected") { ?>
                                                    <button type="submit" name="pending_btn"
                                                        data-tooltip="در انتظار بررسی فاکتور"
                                                        class="btn tooltip-icon btn_icon"><i
                                                            class="fa-regular fa-triangle-exclamation"></i></button>
                                                    <?php } ?>
                                                    <a href="<?= site_url('register_customer') . '?' . http_build_query(['invoice_id' => $row->id]) ?>"
                                                        data-tooltip="ثبت و ویرایش اطلاعات مشتری مربوطه"
                                                        class="btn tooltip-icon btn_icon"><i
                                                            class="fa-light fa-user"></i></a>
                                                    <?php } else { ?>
                                                    <a data-tooltip="مشاهده" class="btn tooltip-icon btn_icon"
                                                        href="show_invoice?action_show= <?= $row->transaction_id ?>"><i
                                                            class="fa-regular fa-eye"></i></a>
                                                    <?php  } ?>
                                                    <?php if($role == "representative"){ ?>
                                                    <?php if($result || $row->status == "rejected"){ ?>
                                                    <a href="#<?= $row->agent_id ?>" data-bs-toggle="modal"
                                                        data-tooltip="مشاهده علت رد"
                                                        class="btn tooltip-icon btn_icon"><i
                                                            class="fa-regular fa-triangle-exclamation"></i></a>
                                                    <?php } ?>
                                                    <a href="<?= site_url('register_customer') . '?' . http_build_query(['invoice_id' => $row->id]) ?>"
                                                        data-tooltip="ثبت و ویرایش اطلاعات مشتری مربوطه"
                                                        class="btn tooltip-icon btn_icon"><i
                                                            class="fa-light fa-user"></i></a>
                                                    <?php } ?>
                                                </form>
                                            </div>
                                        </td>
                                        <td><?= jdate("Y/m/d", strtotime($row->created_at)) . " ~ " . date("H:i", strtotime($row->created_at)) ?>
                                        </td>
                                        <?php if ($role == "regional_manager") { ?>
                                        <td>
                                            <div class="text-center">
                                                <a style="color: red;" href="#"
                                                    class="delete-btn btn tooltip-icon btn_icon" data-tooltip="حذف"
                                                    data-url="<?= site_url("manager_invoice/?action_delete=$row->transaction_id") ?>">
                                                    <i class="fa-regular fa-trash"></i>
                                                </a>
                                                <a href="#<?= $row->id ?>" data-bs-toggle="modal"
                                                    data-tooltip="مشاهده رسید" class="btn tooltip-icon btn_icon"><i
                                                        class="fa-regular fa-eye"></i></a>
                                            </div>
                                        </td>
                                        <?php } ?>
                                        <?php if ($role == "admin" || $role == "admin_site" || $role == "representative"){  ?>
                                        <td>
                                            <div class="text-center">
                                                <?php if ($role == "admin" || $role == "admin_site"){  ?>
                                                <a href="#<?= $row->id ?>" data-bs-toggle="modal"
                                                    data-tooltip="مشاهده رسید" class="btn tooltip-icon btn_icon">
                                                    <i class="fa-regular fa-eye"></i>
                                                </a>
                                                <?php } ?>

                                                <?php if($role == "representative"){ ?>
                                                <a href="#<?= $row->id ?>" data-bs-toggle="modal"
                                                    data-tooltip="مشاهده رسید" class="btn tooltip-icon btn_icon">
                                                    <i class="fa-regular fa-eye"></i>
                                                </a>
                                                <?php if($row->status == "pending" || $row->status == "rejected"){ ?>
                                                <a href="send_img_arrived/?action_show=<?= $row->id ?>"
                                                    name="approved_btn" data-tooltip="ارسال رسید"
                                                    class="btn tooltip-icon btn_icon">
                                                    <i class="fa-regular fa-check"></i>
                                                </a>
                                                <?php } ?>
                                                <?php } ?>
                                            </div>
                                        </td>
                                        <?php } ?>
                                    </tr>


                                    <!-- Start popup -->
                                    <div class="modal fade" id="<?= $row->agent_id ?>">
                                        <div class="modal-dialog modal-dialog-scrollable">
                                            <div class="modal-content custom_modal_content">
                                                <div class="modal-header" style="padding: 5%;">
                                                    <h2 class="modal-title>
                                                        <i
                                                            class=" fa-light fa-triangle-exclamation custom_icon_modal
                                                        modal_item_icon"></i>
                                                        مشاهده علت رد
                                                    </h2>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body" style="padding: 5%;">
                                                    <?php if($result){ ?>
                                                    <div style="font-size: 20px;color:red"><?= $result->description ?>
                                                    </div>
                                                    <?php }else{ ?>
                                                    <div style="font-size: 20px;color:red">علت رد تعریف نشده است</div>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- End popup -->

                                    <!-- Start popup -->
                                    <div class="modal fade" id="<?= $row->id ?>">
                                        <div class="modal-dialog modal-dialog-scrollable">
                                            <div class="modal-content custom_modal_content">
                                                <div class="modal-header" style="padding: 5%;">
                                                    <h2 class="modal-title">
                                                        <i
                                                            class="fa-light fa-camera custom_icon_modal modal_item_icon"></i>
                                                        مشاهده رسید ها
                                                        <?php
                                            $result = get_result_arrived($row->id);
                                            if (!empty($result)) { // بررسی می‌کنیم که مقدار null یا خالی نباشد
                                                $images = explode(",", $result->img_arrived); // مستقیم مقدار رشته را به explode می‌دهیم
                                            } else {
                                                $images = []; // مقدار پیش‌فرض برای جلوگیری از خطا
                                            }
                                            ?>
                                                    </h2>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body" style="padding: 5%;">
                                                    <form action="" method="post">
                                                        <div class="row img_arrived text-center ">
                                                            <?php if ($result) {
                                                    foreach ($images as $img):
                                                ?>
                                                            <div class="col-xl-4 col-xs-12 ">
                                                                <?php if($role == "representative" && $row->status == "pending" || $row->status == "rejected"){ ?>
                                                                <button type="submit" name="delete_single_image"
                                                                    class="btn">
                                                                    <i class="fa-regular fa-trash icon_action"></i>
                                                                </button>
                                                                <?php } ?>
                                                                <a class="show_img_arrived" target="_blank"
                                                                    href="<?= $img ?>"><img class="img-fluid"
                                                                        src="<?= $img ?>" alt="" srcset=""></a>
                                                            </div>
                                                            <input type="hidden" name="arrived_id"
                                                                value="<?= $result->id ?>">
                                                            <input type="hidden" name="img_url" value="<?= $img ?>">
                                                            <?php endforeach ?>
                                                            <?php } else { ?>
                                                            <div style="font-size: 20px;">تصویری بارگذاری نشده است</div>
                                                            <?php } ?>
                                                        </div>
                                                    </form>
                                                </div>
                                                <?php if ($role == "representative" && $row->status == "pending" || $row->status == "rejected") { ?>
                                                <div class="modal-footer d-inline text-center">
                                                    <div class="action_delete_arrived">
                                                        <form action="" method="post">
                                                            <?php if ($result) { ?>
                                                            <input type="hidden" name="arrived_id"
                                                                value="<?= $result->id ?>">
                                                            <?php } ?>
                                                            <?php if (!$result) { ?>
                                                            <button type="submit" disabled name="" class="btn">
                                                                <i class="fa-regular fa-trash icon_action"></i>
                                                                حذف تمام تصاویر
                                                            </button>
                                                            <?php } else { ?>
                                                            <button type="submit" name="delete_arrived" class="btn">
                                                                <i class="fa-regular fa-trash icon_action"></i>
                                                                حذف تمام تصاویر
                                                            </button>
                                                            <?php } ?>
                                                        </form>
                                                    </div>
                                                </div>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- End popup -->

                                    <?php endforeach; ?>
                                    <?php else : ?>
                                    <tr>
                                        <td colspan='6'>هیچ فاکتوری یافت نشد</td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                </div>


                <!-- Pagination -->
                <nav aria-label="Page navigation">
                    <ul class="pagination justify-content-center">
                        <?php
                        $pagination_links = paginate_links([
                            'total' => $total_pages,
                            'current' => $paged,
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'array',
                            'end_size' => 1,
                            'mid_size' => 2,
                            'prev_next' => true,
                            'prev_text' => __('قبلی'),
                            'next_text' => __('بعدی'),
                            'add_args' => false,
                            'add_fragment' => '',
                        ]);

                        if ($pagination_links) {
                            foreach ($pagination_links as $link) {
                                $active_class = (strpos($link, 'current') !== false) ? 'active' : '';
                                echo '<li class="page-item ' . $active_class . '">' . str_replace('page-numbers', 'page-link', $link) . '</li>';
                            }
                        }
                        ?>
                    </ul>
                </nav>
                <!-- End Pagination -->
                </form>
            </div>
        </div>
    </div>
    <!-- End::row-1 -->

</div>
</div>
<!-- End::app-content -->

<!-- message sweetalert -->
<script>
document.addEventListener("DOMContentLoaded", function() {
    document.querySelectorAll(".delete-btn").forEach(button => {
        button.addEventListener("click", function(event) {
            event.preventDefault(); // جلوگیری از رفتن به لینک مستقیماً

            let deleteUrl = this.getAttribute("data-url"); // گرفتن لینک حذف

            Swal.fire({
                title: "آیا مطمئن هستید؟",
                text: "این عملیات قابل بازگشت نیست!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#db4040",
                cancelButtonColor: "#3085d6",
                confirmButtonText: "بله، حذف شود!",
                cancelButtonText: "لغو"
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href =
                        deleteUrl; // انتقال به لینک حذف در صورت تأیید
                }
            });
        });
    });
});
</script>
<!-- end message sweetalert -->

<!-- Footer Start -->
<?php get_footer(); ?>
<!-- Footer End -->