<?php
/*
Template Name:  وروود
*/
unset($_SESSION['user_info']);
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl" data-nav-layout="vertical" data-theme-mode="light" data-header-styles="light" data-menu-styles="dark" data-toggled="close">

<head>

    <!-- Meta Data -->
    <meta charset="UTF-8">
    <meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=no'>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title> <?= get_the_title() ?> </title>
    <meta name="Description" content="Bootstrap Responsive Admin Web Dashboard HTML5 Template">
    <meta name="Author" content="Spruko Technologies Private Limited">
    <meta name="keywords" content="admin,admin dashboard,admin panel,admin template,bootstrap,clean,dashboard,flat,jquery,modern,responsive,premium admin templates,responsive admin,ui,ui kit.">

    <!-- Favicon -->
    <?php if (function_exists('get_site_icon_url') && has_site_icon()) : ?>
        <link rel="icon" href="<?php echo esc_url(get_site_icon_url()); ?>" type="image/png">
    <?php endif; ?>

    <script
        src="<?php echo get_template_directory_uri(); ?>/assets/libs/choices.js/public/assets/scripts/choices.min.js">
    </script>

    <!-- Bootstrap Css -->
    <link id="style" href="<?php echo get_template_directory_uri(); ?>/assets/libs/bootstrap/css/bootstrap.min.css"
        rel="stylesheet">

    <!-- Style Css -->
    <link href="<?php echo get_template_directory_uri(); ?>/style.css" rel="stylesheet">

    <!-- Icons Css -->
    <link href="<?php echo get_template_directory_uri(); ?>/assets/css/icons.css" rel="stylesheet">


    <!-- Choices Css -->
    <link rel="stylesheet"
        href="<?php echo get_template_directory_uri(); ?>/assets/libs/choices.js/public/assets/styles/choices.min.css">


    <!-- Custom Css -->
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/custom.css">

    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/libs/swiper/swiper-bundle.min.css">
    <!-- Sweetalerts CSS -->

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class="error-1">

    <div class="page main-signin-wrapper">
        <?php
        include  'actions/action-users.php';
        ?>
        <!-- Start::row-1 -->
        <div class="row signpages">
            <div class="col-md-12">
                <div class="card">
                    <div class="row row-sm">
                        <div class="col-lg-12 col-xl-12 col-xs-12 col-sm-12 login_form ">
                            <div class="main-container container-fluid">
                                <div class="row row-sm">
                                    <div class="card-body">
                                        <div class="clearfix"></div>
                                        <h3 class=" mb-2 titr_rigester">ورود</h3>
                                        <div class="card-body" style="border-bottom: 1px solid #cfcfcf; padding:20px">
                                            <form class="row g-3 mt-0 new-user" action="" method="post" enctype="multipart/form-data">
                                                <div class=" col-md-12">
                                                    <label class="form-label">نام کاربری<span class="required">*</span></label>
                                                    <input type="text" name="username" class="form-control nofarsi"
                                                        placeholder="نام کاربری را وارد نمایید" value="<?= old('username') ?>">
                                                </div>
                                                <div class="col-md-12">
                                                    <label for="inputPassword" class="form-label">رمز عبور<span class="required">*</span></label>
                                                    <div class="input-group">
                                                        <input type="password" name="password" class="form-control inputPassword nofarsi" placeholder="رمز عبور را وارد نمایید">
                                                        <span class="input-group-text togglePassword login-register" style="cursor: pointer;">
                                                            <i class="fas fa-eye"></i>
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="col-12 text-center">
                                                    <button type="submit" name="login-user" class="btn btn-success btn-lg text">ورود به حساب کاربری</button>
                                                </div>
                                            </form>
                                        </div>
                                        <div class=" mt-3 ms-0">
                                            <p class="mb-0">اگر حساب کاربری ندارید <a href="<?= site_url('register') ?>">ایجاد حساب</a> کنید</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- End::row-1 -->

    </div>

    <!-- Custom-Switcher JS -->
    <script src="<?= get_template_directory_uri() ?>/assets/js/custom-switcher.min.js"></script>

    <!-- Bootstrap JS -->
    <script src="<?= get_template_directory_uri() ?>/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Custom JS -->
    <script src="<?php echo get_template_directory_uri(); ?>/assets/js/custom.js" defer></script>
    <script src="<?php echo get_template_directory_uri(); ?>/assets/js/script.js" defer></script>

</body>

</html>