<?php
/*
Template Name: ویرایش محصول
*/
include 'actions/action-product.php';
if (!isset($_GET['action_edit']) || empty($_GET['action_edit']) && !isset($_GET['update']) && empty($_GET['update'])) {
    header('Location: ' . site_url('products-list'));
    exit;
} else {
    $key = $_GET['action_edit'];
    $table = "custom_products";
    $row = get_result_key($table, $key);
    if (!$row || $row->key_protection != $key) {
        header("location:products-list");
    }
    // Set the dynamic title
    add_filter('wp_title', function($title) use ($row) {
        return 'ویرایش محصول ' . "($row->name_product)";
    });

    add_filter('the_title', function($title) use ($row) {
        return 'ویرایش محصول ' . "($row->name_product)";
    });
}
get_header();
get_sidebar();
?>

<!-- Start::app-content -->
<div class="main-content app-content">
    <div class="container-fluid">

        <!-- Page Header -->

        <div class="d-md-flex d-block align-items-center justify-content-between page-header-breadcrumb">
            <div>
                <h2 class="main-content-title fs-24 mb-1">ویرایش محصول (<?= $row->name_product ?>)</h2>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">محصولات</a></li>
                    <li class="breadcrumb-item active" aria-current="page">ویرایش محصول</li>
                </ol>
            </div>

        </div>

        <!-- Page Header Close -->
        <?php
        if (!empty($message)) {
            echo "
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                    document.body.classList.add('swal-open'); 
                    Swal.fire({
                        icon: 'error',
                        title: 'خطا!',
                        html: '$message',
                        confirmButtonText: 'متوجه شدم',
                        timer: 5000,
                        timerProgressBar: true,
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        didOpen: () => {
                            document.querySelector('.swal2-container').classList.add('swal-active');
                        },
                        willClose: () => {
                            document.body.classList.remove('swal-open');
                            document.querySelector('.swal-overlay').remove();
                        },
                    });
                });
            </script>
            ";
        }
        ?>

        <!-- Start:: row-1 -->
        <div class="row row-sm">
            <div class="col-xl-9" style="margin: 0 auto;">
                <div class="card custom-card">
                    <div class="card-header custom-card-header justify-content-between">
                        <div class="card-title">
                            <i class="fa-regular fa-cart-shopping custom-icon"></i>
                            ویرایش محصول <?= $row->name_product ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="row g-3 mt-0 new-product" action="" method="post" enctype="multipart/form-data">
                            <input type="text" name="key_protection" hidden class="form-control"
                                value="<?= $row->key_protection ?>">
                            <div class="col-md-6">
                                <label class="form-label">اسم محصول<span class="required">*</span></label>
                                <input id="title_input" type="text" name="name_product" class="form-control"
                                    placeholder="اسم محصول را وارد نمایید" value="<?= $row->name_product ?>">
                            </div>
                            <div class=" col-md-6">
                                <label class="form-label">نامک محصول<span class="required">*</span></label>
                                <input id="slug_input" type="text" name="slug" class="form-control nofarsi"
                                    placeholder="نامک محصول را وارد نمایید" value="<?= $row->slug ?>">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">قیمت محصول <sup>بر حسب تومان</sup> <span
                                        class="required">*</span></label>
                                <input type="text" name="price" class="form-control price"
                                    placeholder="قیمت محصول را وارد نمایید" value="<?= $row->price ?>">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">موجودی<span
                                        class="required">*</span></label>
                                <input type="number" name="count_product" class="form-control price"
                                    placeholder="تعداد موجودی محصول را وارد نمایید" value="<?= $row->count_product ?>">
                            </div>
                            <div class="col-md-4">
                                <label for="inputState" class="form-label">وضعیت</label>
                                <select name="status" id="inputState" class="form-select form-select-lg">
                                    <option value="active" <?= $row->status == 'active' ? 'selected' : '' ?>>انتشار</option>
                                    <option value="deactive" <?= $row->status == 'deactive' ? 'selected' : '' ?>>پیش نویس</option>
                                </select>
                            </div>

                            <div class="col-12">
                                <div class="mb-4 main-content-label">تصویر محصول</div>
                                <input type="file" name="img_product" id="imageUpload" class="form-control">
                                <div class="container-preview text-center img-fluid">
                                    <img id="preview" style="display: block;" src="<?= $row->img_product?>" alt="پیشنمایش تصویر محصول" class="mt-2 img-prev" />
                                </div>
                            </div>
                            <div class="col-12 text-center">
                                <button type="submit" name="update-product" class="btn btn-primary btn-lg text">ویرایش
                                    محصول</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- End:: row-1 -->
    </div>
</div>
<!-- End::app-content -->

<!-- Footer Start -->
<?php get_footer() ?>
<!-- Footer End -->