<?php
check_access();
/*
Template Name: ویرایش بانک
*/
include 'actions/action-bank.php';
if (!isset($_GET['action_edit']) || empty($_GET['action_edit']) && !isset($_GET['update']) && empty($_GET['update'])) {
    header('Location: ' . site_url('banks'));
    exit;
} else {
    $key = $key = $_GET['action_edit'];
    $table = "custom_banks";
    $row = get_result_key($table, $key);
    if (!$row || $row->key_protection != $key) {
        header("location:banks");
    }
    // Set the dynamic title
    add_filter('wp_title', function ($title) use ($row) {
        return 'ویرایش بانک ' . "($row->bank_name)";
    });

    add_filter('the_title', function ($title) use ($row) {
        return 'ویرایش بانک ' . "($row->bank_name)";
    });
}
get_header();
include 'sidebar.php';
?>

<!-- Start::app-content -->
<div class="main-content app-content">
    <div class="container-fluid">

        <!-- Page Header -->

        <div class="d-md-flex d-block align-items-center justify-content-between page-header-breadcrumb">
            <div>
                <h2 class="main-content-title fs-24 mb-1">ویرایش بانک (<?= $row->bank_name ?>)</h2>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">بانکات</a></li>
                    <li class="breadcrumb-item active" aria-current="page">ویرایش بانک</li>
                </ol>
            </div>

        </div>

        <!-- Page Header Close -->
        <?php
        if (!empty($message)) {
            echo "
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                    document.body.classList.add('swal-open'); 
                    Swal.fire({
                        icon: 'error',
                        title: 'خطا!',
                        html: '$message',
                        confirmButtonText: 'متوجه شدم',
                        timer: 5000,
                        timerProgressBar: true,
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        didOpen: () => {
                            document.querySelector('.swal2-container').classList.add('swal-active');
                        },
                        willClose: () => {
                            document.body.classList.remove('swal-open');
                            document.querySelector('.swal-overlay').remove();
                        },
                    });
                });
            </script>
            ";
        }
        ?>

        <!-- Start:: row-1 -->
        <div class="row row-sm">
            <div class="col-xl-9" style="margin: 0 auto;">
                <div class="card custom-card">
                    <div class="card-header custom-card-header justify-content-between">
                        <div class="card-title">
                            <i class="fa-regular fa-building-columns custom-icon"></i>
                            ویرایش بانک <?= $row->bank_name ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="row g-3 mt-0 new-product" action="" method="post" enctype="multipart/form-data">
                            <input type="text" name="key_protection" hidden class="form-control"
                                value="<?= $row->key_protection ?>">
                            <div class="col-md-6">
                                <label class="form-label">اسم بانک<span class="required">*</span></label>
                                <input id="title_input" type="text" name="bank_name" class="form-control"
                                    placeholder="اسم بانک را وارد نمایید" value="<?= $row->bank_name ?>">
                            </div>
                            <div class=" col-md-6">
                                <label class="form-label">نامک بانک<span class="required">*</span></label>
                                <input id="slug_input" type="text" name="slug" class="form-control nofarsi"
                                    placeholder="نامک بانک را وارد نمایید" value="<?= $row->slug ?>">
                            </div>
                            <div class="col-md-4">
                                <label for="inputState" class="form-label">وضعیت</label>
                                <select name="status" id="inputState" class="form-select form-select-lg">
                                    <option value="active" <?= $row->status == 'active' ? 'selected' : '' ?>>فعال
                                    </option>
                                    <option value="inactive" <?= $row->status == 'inactive' ? 'selected' : '' ?>>غیر
                                        فعال</option>
                                </select>
                            </div>

                            <div class="col-12">
                                <div class="mb-4 main-content-label">لوگوی بانک</div>
                                <input type="file" name="logo_url" id="imageUpload" class="form-control">
                                <div class="container-preview text-center img-fluid">
                                    <img id="preview" style="display: block;" src="<?= $row->logo_url ?>"
                                        alt="پیشنمایش تصویر بانک" class="mt-2 img-prev" />
                                </div>
                            </div>
                            <div class="col-12 text-center">
                                <button type="submit" name="update-bank" class="btn btn-primary btn-lg text">ویرایش
                                    بانک</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- End:: row-1 -->
    </div>
</div>
<!-- End::app-content -->

<!-- Footer Start -->
<?php get_footer() ?>
<!-- Footer End -->