<?php
/*
Template Name: لیست اقساط
*/
echo '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>';
if (isset($_GET['action_delete']) && !empty($_GET['action_delete'])) {
    $table = "custom_aghsat";
    $cand_delete = can_delete_item("ghest", $_GET['action_delete']);
    if ($cand_delete !== true) {
        $cand_delete_escaped = json_encode($cand_delete, JSON_UNESCAPED_UNICODE);
        echo "
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
                document.body.classList.add('swal-open'); 
                Swal.fire({
                    icon: 'error',
                    title: 'خطا',
                    html: $cand_delete_escaped,
                    confirmButtonText: 'متوجه شدم',
                    willClose: () => {
                        document.body.classList.remove('swal-open');
                        document.querySelector('.swal-overlay').remove();
                    },
                }).then(() => {
                    // حذف کوئری استرینگ بدون رفرش صفحه
                    const newUrl = window.location.origin + window.location.pathname;
                    history.replaceState(null, '', newUrl);
                });
            });
        </script>
        ";
    }
    else{
    $delete = get_delete($table, $_GET['action_delete']);
    if ($delete) {
        header("Location:" . site_url('aghsat/?delete=success'));
        exit;
    }
}
}
if (isset($_GET['delete']) && $_GET['delete'] == 'success') {
    echo "
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.body.insertAdjacentHTML('beforeend', '<div class=\"swal-overlay\"></div>'); 
            document.body.classList.add('swal-open'); 
            Swal.fire({
                icon: 'success',
                title: 'حذف موفقیت آمیز!',
                text: 'قسط با موفقیت حذف شد',
                confirmButtonText: 'متوجه شدم',
                timer: 5000,
                timerProgressBar: true,
                willClose: () => {
                            document.body.classList.remove('swal-open');
                            document.querySelector('.swal-overlay').remove();
                        },
            }).then(() => {
            // حذف کوئری استرینگ بدون رفرش صفحه
            const newUrl = window.location.origin + window.location.pathname;
            history.replaceState(null, '', newUrl);
        });
        });
    </script>
    ";
}
$user_role = $_SESSION['user_info']['user_role'];
get_header();
include 'sidebar.php';
?>

<!-- Start::app-content -->
<div class="main-content app-content">
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="d-md-flex d-block align-items-center justify-content-between page-header-breadcrumb">
            <div>
                <h2 class="main-content-title fs-24 mb-1">لیست اقساط</h2>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">اقساط</a></li>
                    <li class="breadcrumb-item active" aria-current="page">لیست اقساط</li>
                </ol>
            </div>
        </div>
        <!-- Page Header Close -->

        <!-- Start::row-1 -->
        <div class="row">
            <div class="card custom-card">
                <div class="card-body">
                    <div class="row rows">
                        <div class="col-xl-4 searched">
                            <form action="" name="search" method="get" class="search-form">
                                <div class="input-group slector">
                                    <div class="input-group-btn search-panel" style="height: 40px;">
                                        <select class="js-example-basic-single" name="status" data-trigger>
                                            <option value="" hidden selected>انتخاب بر اساس</option>
                                            <option value="active">فعال</option>
                                            <option value="inactive">غیر فعال</option>
                                        </select>
                                    </div>
                                    <input type="text" class="form-control" name="q" placeholder="جست و جو کنید..."
                                        autocomplete="off">
                                    <button type="submit" class="btn btn-primary"><i class="fe fe-search"
                                            aria-hidden="true"></i></button>
                                </div>
                            </form>
                        </div>
                    </div>

                    <?php
                    $paged = (get_query_var('paged')) ? absint(get_query_var('paged')) : 1;
                    $posts_per_page = 10;

                    $status = isset($_GET['status']) ? $_GET['status'] : '';
                    $q = isset($_GET['q']) ? $_GET['q'] : '';

                    $data = get_result_aghsat('custom_aghsat', $q, $status, $paged, $posts_per_page);
                    $results = $data['results'];
                    $total_pages = $data['total_pages'];
                    ?>

                    <form action="" class="form" method="post">
                        <div class="table-responsive custom-scrollbar">
                            <table class="table text-nowrap table-bordered table-hover">
                                <thead class="head-users-table">
                                    <tr>
                                        <th>بانک انتخابی</th>
                                        <th>مدت زمان قسط</th>
                                        <th>سود قسط</th>
                                        <th>وضعیت</th>
                                        <th>تاریخ انتشار</th>
                                        <?php if($user_role == "admin" || $user_role == "admin_site") { ?>
                                        <th>عملیات</th>
                                        <?php } ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($results) : ?>
                                        <?php foreach ($results as $row) : ?>
                                            <tr>
                                                <td><?= $row->bank_name ?></td>
                                                <td><?= $row->ghest_time ?> ماهه</td>
                                                <td>
                                                    <?= $row->sood ?> ٪
                                                </td>
                                                <td>
                                                    <span
                                                        class="badge <?= ($row->status == 'active') ? 'bg-success' : 'bg-warning' ?>">
                                                        <?= ($row->status == 'active') ? 'فعال' : 'غیر فعال' ?>
                                                    </span>
                                                </td>
                                                <td><?= jdate("Y/m/d", strtotime($row->created_at)) . " ~ " . date("H:i", strtotime($row->created_at)) ?>
                                                </td>
                                                <?php if($user_role == "admin" || $user_role == "admin_site") { ?>
                                                <td>
                                                    <div class="hstack gap-2 flex-wrap">
                                                        <a href="<?= site_url("edit-ghest/?action_edit=$row->key_protection") ?>"
                                                            class="text-info fs-14 lh-1"><i class="ri-edit-line"></i></a>
                                                        <a href="#" class="text-danger fs-14 lh-1 delete-btn"
                                                            data-url="<?= site_url("aghsat/?action_delete=$row->id") ?>">
                                                            <i class="ri-delete-bin-5-line"></i>
                                                        </a>

                                                    </div>
                                                </td>
                                                <?php } ?>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else : ?>
                                        <tr>
                                            <td colspan='6'>هیچ قسطی یافت نشد</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <nav aria-label="Page navigation">
                            <ul class="pagination justify-content-center">
                                <?php
                                $pagination_links = paginate_links([
                                    'total' => $total_pages,
                                    'current' => $paged,
                                    'format' => '?paged=%#%',
                                    'show_all' => false,
                                    'type' => 'array',
                                    'end_size' => 1,
                                    'mid_size' => 2,
                                    'prev_next' => true,
                                    'prev_text' => __('قبلی'),
                                    'next_text' => __('بعدی'),
                                    'add_args' => false,
                                    'add_fragment' => '',
                                ]);

                                if ($pagination_links) {
                                    foreach ($pagination_links as $link) {
                                        $active_class = (strpos($link, 'current') !== false) ? 'active' : '';
                                        echo '<li class="page-item ' . $active_class . '">' . str_replace('page-numbers', 'page-link', $link) . '</li>';
                                    }
                                }
                                ?>
                            </ul>
                        </nav>
                        <!-- End Pagination -->

                    </form>
                </div>
            </div>
        </div>
        <!-- End::row-1 -->

    </div>
</div>
<!-- End::app-content -->

<!-- message sweetalert -->
<script>
    document.addEventListener("DOMContentLoaded", function() {
        document.querySelectorAll(".delete-btn").forEach(button => {
            button.addEventListener("click", function(event) {
                event.preventDefault(); // جلوگیری از رفتن به لینک مستقیماً

                let deleteUrl = this.getAttribute("data-url"); // گرفتن لینک حذف

                Swal.fire({
                    title: "آیا مطمئن هستید؟",
                    text: "این عملیات قابل بازگشت نیست!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#db4040",
                    cancelButtonColor: "#3085d6",
                    confirmButtonText: "بله، حذف شود!",
                    cancelButtonText: "لغو"
                }).then((result) => {
                    if (result.isConfirmed) {
                        window.location.href =
                            deleteUrl; // انتقال به لینک حذف در صورت تأیید
                    }
                });
            });
        });
    });
</script>
<!-- end message sweetalert -->

<!-- Footer Start -->
<?php get_footer(); ?>
<!-- Footer End -->