<?php

if (isset($_POST['save-user'])) {
    global $wpdb;
    $table = 'custom_users';
    $messages = [];
    $password = null;
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $postal_code = sanitize_text_field($_POST['postal_code']);
    $phone = $_POST['phone'];
    $username = sanitize_text_field($_POST['username']);
    $email = sanitize_email($_POST['email']);
    $Key = trim($_POST['key_protection']); // اگر `id` وجود داشت، مقدار عددی آن را بگیر
    $parent_id = null;
    $user_info = $_SESSION['user_info'];
    $user_role = $user_info['user_role'];
    // بررسی وجود `slug` در دیتابیس
    $existing_postal_code = $wpdb->get_var(
        $wpdb->prepare("SELECT key_protection FROM {$wpdb->prefix}$table WHERE postal_code = %s AND key_protection != %s", $postal_code, $Key)
    );
    $existing_phone = $wpdb->get_var(
        $wpdb->prepare("SELECT key_protection FROM {$wpdb->prefix}$table WHERE phone = %s AND key_protection != %s", $phone, $Key)
    );
    $existing_email = $wpdb->get_var(
        $wpdb->prepare("SELECT key_protection FROM {$wpdb->prefix}$table WHERE email = %s AND key_protection != %s", $email, $Key)
    );

    $existing_username = $wpdb->get_var(
        $wpdb->prepare("SELECT key_protection FROM {$wpdb->prefix}$table WHERE username = %s AND key_protection != %s", $username, $Key)
    );

    if ($existing_postal_code) {
        $messages[] = 'این کد ملی قبلا ثبت شده';
    }
    if ($existing_phone) {
        $messages[] = 'این شماره همراه قبلا ثبت شده';
    }
    if ($existing_email) {
        $messages[] = 'این ایمیل قبلا ثبت شده است';
    }
    if ($existing_username) {
        $messages[] = 'این نام کاربری قبلا ثبت شده است';
    }

    if (!empty($messages)) {
        $message = implode('<br>', $messages);
    } else {
        if ($user_role == "admin" || $user_role == "admin_site") {
            $fields = [
                'key_protection',
                'fl_name',
                'postal_code',
                'phone',
                'email',
                'username',
                'password',
                'province',
                'city',
                'zipcode',
                'address',
                'madrak',
                'user_role',
            ];
            if (!empty($_FILES['profile']['tmp_name'])) {
                $fields[] = 'profile';
            }
            handleFormSubmission(
                $table,
                $fields,
                [
                    'fl_name' => 'نام و نام خانوادگی',
                    'postal_code' => 'کد ملی',
                    'email' => 'ایمیل',
                    'username' => 'نام کاربری',
                    'phone' => 'شماره همراه',
                    'password' => 'رمز عبور',
                    'province' => 'استان',
                    'city' => 'شهر',
                    'zipcode' => 'کد پستی',
                    'address' => 'آدرس',
                    'madrak' => 'مدرک تحصیلی',
                    'user_role' => 'نقش کاربری',
                    'profile' => 'تصویر پروفایل',
                ],
                [
                    'password' => ['min_length' => 8]
                ]
            );
        } else {
            $fields = [
                'key_protection',
                'fl_name',
                'postal_code',
                'phone',
                'email',
                'username',
                'password',
                'province',
                'city',
                'zipcode',
                'address',
                'madrak',
                'user_role',
                'parent_id'
            ];
            if (!empty($_FILES['profile']['tmp_name'])) {
                $fields[] = 'profile';
            }
            handleFormSubmission(
                $table,
                $fields,
                [
                    'fl_name' => 'نام و نام خانوادگی',
                    'postal_code' => 'کد ملی',
                    'email' => 'ایمیل',
                    'username' => 'نام کاربری',
                    'phone' => 'شماره همراه',
                    'password' => 'رمز عبور',
                    'province' => 'استان',
                    'city' => 'شهر',
                    'zipcode' => 'کد پستی',
                    'address' => 'آدرس',
                    'madrak' => 'مدرک تحصیلی',
                    'user_role' => 'نقش کاربری',
                    'profile' => 'تصویر پروفایل',
                    'parent_id' => 'شناسه والد'
                ],
                [
                    'password' => ['min_length' => 8]
                ]
            );
        }
    }
}

if (isset($_POST['register-user'])) {
    global $wpdb;
    $table = 'custom_users';
    $messages = [];
    $password = null;
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $postal_code = sanitize_text_field($_POST['postal_code']);
    $phone = $_POST['phone'];
    $username = sanitize_text_field($_POST['username']);
    $email = sanitize_email($_POST['email']);
    $Key = trim($_POST['key_protection']); // اگر `id` وجود داشت، مقدار عددی آن را بگیر

    $existing_postal_code = $wpdb->get_var(
        $wpdb->prepare("SELECT key_protection FROM {$wpdb->prefix}$table WHERE postal_code = %s AND key_protection != %s", $postal_code, $Key)
    );
    $existing_phone = $wpdb->get_var(
        $wpdb->prepare("SELECT key_protection FROM {$wpdb->prefix}$table WHERE phone = %s AND key_protection != %s", $phone, $Key)
    );
    $existing_email = $wpdb->get_var(
        $wpdb->prepare("SELECT key_protection FROM {$wpdb->prefix}$table WHERE email = %s AND key_protection != %s", $email, $Key)
    );

    $existing_username = $wpdb->get_var(
        $wpdb->prepare("SELECT key_protection FROM {$wpdb->prefix}$table WHERE username = %s AND key_protection != %s", $username, $Key)
    );

    if ($existing_postal_code) {
        $messages[] = 'این کد ملی قبلا ثبت شده';
    }
    if ($existing_phone) {
        $messages[] = 'این شماره همراه قبلا ثبت شده';
    }
    if ($existing_email) {
        $messages[] = 'این ایمیل قبلا ثبت شده است';
    }
    if ($existing_username) {
        $messages[] = 'این نام کاربری قبلا ثبت شده است';
    }

    if (!empty($messages)) {
        $message = implode('<br>', $messages);
    } else {
        $fields = [
            'key_protection',
            'fl_name',
            'postal_code',
            'phone',
            'email',
            'username',
            'password',
            'province',
            'city',
            'zipcode',
            'address',
            'madrak',
            'user_role',
        ];
        if(!empty($_POST['parent_id'])){
            $fields[] = 'parent_id';
        }
        handleFormSubmission(
            $table,
            $fields,
            [
                'fl_name' => 'نام و نام خانوادگی',
                'postal_code' => 'کد ملی',
                'email' => 'ایمیل',
                'username' => 'نام کاربری',
                'phone' => 'شماره همراه',
                'password' => 'رمز عبور',
                'province' => 'استان',
                'city' => 'شهر',
                'zipcode' => 'کد پستی',
                'address' => 'آدرس',
                'madrak' => 'مدرک تحصیلی',
                'user_role' => 'نقش کاربری',
                'profile' => 'تصویر پروفایل',
            ],
            [
                'password' => ['min_length' => 8]

            ]
        );
    }
}

if (isset($_POST['login-user'])) {
    custom_login($_POST['username'], $_POST['password']);
}

if (isset($_POST['update-user'])) {
    global $wpdb;
    $table = 'custom_users';
    $messages = [];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $postal_code = sanitize_text_field($_POST['postal_code']);
    $phone = $_POST['phone'];
    $username = sanitize_text_field($_POST['username']);
    $email = sanitize_email($_POST['email']);
    $Key = trim($_POST['key_protection']);
    // دریافت مقدارهای موجود از دیتابیس
    $existing_postal_code = $wpdb->get_var($wpdb->prepare("SELECT key_protection FROM {$wpdb->prefix}$table WHERE postal_code = %s", $postal_code));
    $existing_phone = $wpdb->get_var($wpdb->prepare("SELECT key_protection FROM {$wpdb->prefix}$table WHERE phone = %s", $phone));
    $existing_email = $wpdb->get_var($wpdb->prepare("SELECT key_protection FROM {$wpdb->prefix}$table WHERE email = %s", $email));
    $existing_username = $wpdb->get_var($wpdb->prepare("SELECT key_protection FROM {$wpdb->prefix}$table WHERE username = %s", $username));

    // بررسی مقادیر تکراری ولی فقط اگر کلید آنها متفاوت باشد
    if ($existing_postal_code && $existing_postal_code != $Key) {
        $messages[] = 'این کد ملی قبلا ثبت شده';
    }
    if ($existing_phone && $existing_phone != $Key) {
        $messages[] = 'این شماره همراه قبلا ثبت شده';
    }
    if ($existing_email && $existing_email != $Key) {
        $messages[] = 'این ایمیل قبلا ثبت شده است';
    }
    if ($existing_username && $existing_username != $Key) {
        $messages[] = 'این نام کاربری قبلا ثبت شده است';
    }

    if (!empty($messages)) {
        $message = implode('<br>', $messages);
    } else {
        $fields = [
            'key_protection',
            'fl_name',
            'postal_code',
            'phone',
            'email',
            'username',
            'province',
            'city',
            'zipcode',
            'address',
            'madrak',
            'user_role'
        ];

        if (!empty($_FILES['profile']['tmp_name'])) {
            $fields[] = 'profile';
        }
        if (!empty($_POST['password'])) {
            $fields[] = 'password';
        }

        handleFormSubmission(
            $table,
            $fields,
            [
                'fl_name' => 'نام و نام خانوادگی',
                'postal_code' => 'کد ملی',
                'email' => 'ایمیل',
                'username' => 'نام کاربری',
                'phone' => 'شماره همراه',
                'province' => 'استان',
                'city' => 'شهر',
                'zipcode' => 'کد پستی',
                'address' => 'آدرس',
                'madrak' => 'مدرک تحصیلی',
                'user_role' => 'نقش کاربری',
                'profile' => 'تصویر پروفایل'
            ],
            [
                'password' => ['min_length' => 8]
            ]
        );
    }
}

if (isset($_POST['change_password'])) {
    $user_id = $user_info['id'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $table = "custom_users";
    changer_password($user_id, $password);
}


if (isset($_POST['save_customer'])) {
    global $wpdb;
    $table = 'custom_customers';
    $messages = [];
    $postal_code = sanitize_text_field($_POST['postal_code']);
    $phone = $_POST['phone_number'];
    $Key = trim($_POST['key_protection']); // اگر `id` وجود داشت، مقدار عددی آن را بگیر

    $existing_postal_code = $wpdb->get_var(
        $wpdb->prepare("SELECT key_protection FROM {$wpdb->prefix}$table WHERE postal_code = %s AND key_protection != %s", $postal_code, $Key)
    );
    $existing_phone = $wpdb->get_var(
        $wpdb->prepare("SELECT key_protection FROM {$wpdb->prefix}$table WHERE phone_number = %s AND key_protection != %s", $phone, $Key)
    );

    if ($existing_postal_code) {
        $messages[] = 'این کد ملی قبلا ثبت شده';
    }
    if ($existing_phone) {
        $messages[] = 'این شماره همراه قبلا ثبت شده';
    }

    if (!empty($messages)) {
        $message = implode('<br>', $messages);
    } else {
        $fields = [
            'key_protection',
            'fl_name',
            'postal_code',
            'phone_number',
            'father_name',
            'loan_amount',
            'zipcode',
            'address',
            'invoice_id',
        ];
        handleFormSubmission(
            $table,
            $fields,
            [
                'fl_name' => 'نام و نام خانوادگی',
                'postal_code' => 'کد ملی',
                'phone_number' => 'شماره همراه',
                'father_name' => 'پدر',
                'loan_amount'=> 'مبلغ وام',
                'zipcode' => 'کد پستی',
                'address' => 'آدرس',
            ],
        );
    }
}