<?php
if (isset($_POST['add_order'])) {
    global $wpdb;
    $table_cart_item = esc_sql($wpdb->prefix . "custom_cart_item");
    $table_orders = esc_sql($wpdb->prefix . "custom_orders"); // نام جدول سفارش‌ها
    $successfull = '';
    $error = '';

    // بررسی وجود transaction_id در ورودی
    $transaction_id =  transaction_generator(); // استفاده از transaction_id موجود یا ایجاد جدید

    // بررسی وجود آیتم‌ها در $_POST['items']
    if (isset($_POST['items']) && is_array($_POST['items'])) {
        foreach ($_POST['items'] as $item) {
            // استخراج مقادیر آیتم
            $product_id = intval($item['product_id']);
            $bank_id = intval($item['bank_id']);
            $ghest_id = intval($item['ghest_id']);
            $session_id = esc_sql($item['session_id']);
            $agent_id = intval($item['agent_id']);
            $price = floatval($item['price']);
            $quantity = intval($item['quantity']);

            // بررسی اینکه این آیتم در سبد خرید وجود دارد
            $ex_item = $wpdb->get_row($wpdb->prepare(
                "SELECT * FROM $table_cart_item WHERE product_id = %d AND bank_id = %d 
                AND ghest_id = %d AND session_id = %s AND agent_id = %d",
                $product_id,
                $bank_id,
                $ghest_id,
                $session_id,
                $agent_id
            ));

            if ($ex_item) {
                // بررسی یکسان بودن اطلاعات
                if (
                    $ex_item->product_id != $product_id || $ex_item->bank_id != $bank_id ||
                    $ex_item->ghest_id != $ghest_id || $ex_item->quantity != $quantity ||
                    $ex_item->price != $price || $ex_item->session_id != $session_id ||
                    $ex_item->agent_id != $agent_id
                ) {
                    $error = esc_html('سفارش ثبت نشد! لطفا مقادیر درست را وارد نمایید.');
                } else {
                    // ارسال transaction_id به تابع AddToOrders
                    AddToOrders($ex_item, $transaction_id);
                    $successfull = esc_html("سفارش شما با موفقیت ثبت شد");
                }
            } else {
                $error = esc_html('آیتم مورد نظر در سبد خرید یافت نشد.');
            }
        }
    } else {
        $error = esc_html('هیچ آیتمی برای ثبت سفارش وجود ندارد.');
    }
}