<?php
if (isset($_POST['add_to_cart_item'])) {
    if (isset($_SESSION['user_info'])) {
        $user_info = $_SESSION['user_info'];
    }
    global $wpdb;
    $bank_id = $_POST['bank_id'];
    $ghest_id = $_POST['ghest_id'];
    $session_id = $user_info['id'];
    if($user_info['user_role'] == 'regional_manager'){
    $agent_id = $_POST['agent'];
    }
    $product_id = intval($_POST['product_id']); // اطمینان از اینکه product_id یک عدد صحیح است
    $table = $wpdb->prefix . "custom_products";
    $cart_table = $wpdb->prefix . "custom_cart_item";
    $product = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table WHERE id = %d", $product_id));

    if ($product === null) {
        echo 'محصول مورد نظر یافت نشد';
        return;
    }

    $quantity = intval($_POST['quantity']); // اطمینان از اینکه quantity یک عدد صحیح است
    $messages = [];
    $cart_item = $wpdb->get_row($wpdb->prepare(
        "SELECT quantity FROM $cart_table WHERE product_id = %d AND bank_id = %d AND ghest_id = %d AND session_id = %s",
        $product_id,
        $bank_id,
        $ghest_id,
        $session_id
    ));
    $old_quantity = $cart_item ? intval($cart_item->quantity) : 0;
    if ($product->count_product < $quantity) {
        $messages[] = 'مقدار انتخاب شده بیش از مقدار موجودی انبار است';
    }

    // بررسی سبد خرید برای پیدا کردن محصولات قبلی
    $existing_cart_item = $wpdb->get_row($wpdb->prepare(
        "SELECT * FROM $cart_table WHERE session_id = %s LIMIT 1",
        $session_id
    ));

    if ($existing_cart_item) {
        // چک کردن اینکه بانک و اقساط محصول جدید با محصول موجود در سبد مطابقت دارد یا نه
       if($user_info['user_role'] == "regional_manager"){
        if ($existing_cart_item->bank_id != $bank_id || $existing_cart_item->ghest_id != $ghest_id || $existing_cart_item->agent_id != $agent_id) {
            $messages[] = 'ابتدا سبد خرید را تکمیل و یا حذف نمایید';
        }
       }else{
        if ($existing_cart_item->bank_id != $bank_id || $existing_cart_item->ghest_id != $ghest_id) {
            $messages[] = 'ابتدا سبد خرید را تکمیل و یا حذف نمایید';
        }
       }
    }


    if (!empty($messages)) {
        $message = implode('<br>', $messages);
    } else {
        $cart_table = $wpdb->prefix . "custom_cart_item";
        $cart_item = $wpdb->get_row($wpdb->prepare("SELECT price FROM $cart_table WHERE product_id = %d", $product_id));

        // حذف اعشار از قیمت و تبدیل به عدد صحیح
        $price = intval(str_replace(',', '', $_POST['price'])) * $quantity;
       if($user_info['user_role'] == 'representative'){
        get_insert_or_update_cart($product_id, $bank_id, $ghest_id, $price, $quantity, $session_id, $session_id);
       }else{
        get_insert_or_update_cart($product_id, $bank_id, $ghest_id, $price, $quantity, $session_id, $agent_id);
       }
        // محاسبه مقدار تغییر در انبار
        $difference = $quantity - $old_quantity;

        // بروزرسانی موجودی انبار
        $wpdb->update(
            $table,
            ['count_product' => $product->count_product - $difference],
            ['id' => $product_id],
            ['%d'],
            ['%d']
        );
       
    }
}

if (isset($_POST['remove_from_cart'])) {
    if (isset($_SESSION['user_info'])) {
        $user_info = $_SESSION['user_info'];
    }
    global $wpdb;
    $session_id = $user_info['id'];
    $cart_id = intval($_POST['cart_id']); // استفاده از cart_id به جای ترکیب چندین فیلد
    $product_id = intval($_POST['product_id']);
    $error = '';
    $successfull = '';
    $cart_table = $wpdb->prefix . "custom_cart_item";
    $product_table = $wpdb->prefix . "custom_products";

    // گرفتن مقدار فعلی محصول در سبد خرید با استفاده از cart_id
    $cart_item = $wpdb->get_row($wpdb->prepare(
        "SELECT quantity FROM $cart_table WHERE id = %d",
        $cart_id
    ));

    if ($cart_item) {
        $quantity = intval($cart_item->quantity);

        // بازگرداندن موجودی محصول به انبار
        $wpdb->query($wpdb->prepare(
            "UPDATE $product_table SET count_product = count_product + %d WHERE id = %d",
            $quantity,
            $product_id
        ));

        // حذف آیتم از سبد خرید با استفاده از cart_id
        $deleted = get_delete_cart($cart_id);

        if ($deleted) {
            $successfull = "محصول با موفقیت از سبد خرید حذف شد";
        } else {
            $error = "حذف محصول با خطا مواجه شد";
        }
    }
}
